/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.model.LicowitchModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.client.shader.PostEffectRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class LicowitchRenderer
extends MobRenderer<LicowitchEntity, LicowitchModel> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/licowitch.png");
    private static final Set<LicowitchEntity> allTeleportingLicowitchOnScreen = new HashSet<LicowitchEntity>();
    private static final LicowitchModel TELEPORTING_MODEL = new LicowitchModel();

    public LicowitchRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new LicowitchModel(), 0.5f);
        this.m_115326_((RenderLayer)new ItemLayer(renderManagerIn.m_234598_()));
        this.m_115326_(new TeleportingDoubleLayer());
    }

    public static void renderEntireBatch(LevelRenderer levelRenderer, PoseStack posestack, int renderTick, Camera camera, float partialTick) {
        for (LicowitchEntity licowitch : allTeleportingLicowitchOnScreen) {
            Vec3 to = licowitch.getTeleportingToPos();
            float progress = licowitch.getTeleportingProgress(partialTick);
            if (to == null || !(progress > 0.0f)) continue;
            Vec3 cameraPos = camera.m_90583_();
            float scale = 0.9375f;
            float bodyYaw = licowitch.f_20884_ + (licowitch.f_20883_ - licowitch.f_20884_) * partialTick;
            float headYaw = Mth.m_14189_((float)partialTick, (float)licowitch.f_20886_, (float)licowitch.f_20885_);
            float netHeadYaw = headYaw - bodyYaw;
            float headPitch = Mth.m_14189_((float)partialTick, (float)licowitch.f_19860_, (float)licowitch.m_146909_());
            try {
                posestack.m_85836_();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            posestack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            posestack.m_85837_(to.f_82479_, to.f_82480_ + 1.5, to.f_82481_);
            posestack.m_85841_(-scale, -scale, scale);
            posestack.m_252781_(Axis.f_252392_.m_252977_(180.0f - bodyYaw));
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer textureBuffer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)TEXTURE));
            TELEPORTING_MODEL.setupAnim(licowitch, licowitch.f_267362_.m_267590_(partialTick), licowitch.f_267362_.m_267711_(partialTick), (float)licowitch.f_19797_ + partialTick, netHeadYaw, headPitch);
            TELEPORTING_MODEL.m_7695_(posestack, textureBuffer, 240, LivingEntityRenderer.m_115338_((LivingEntity)licowitch, (float)0.0f), 1.0f, 1.0f - (1.0f - progress), 1.0f, progress);
            PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.PURPLE_WITCH_SHADER);
            VertexConsumer witchEffectBuffer = bufferSource.m_6299_(ACRenderTypes.getPurpleWitch(TEXTURE));
            TELEPORTING_MODEL.m_7695_(posestack, witchEffectBuffer, 240, LivingEntityRenderer.m_115338_((LivingEntity)licowitch, (float)0.0f), 1.0f, 0.0f, 1.0f, progress);
            posestack.m_85849_();
        }
        allTeleportingLicowitchOnScreen.clear();
    }

    public void render(LicowitchEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        if (entityIn.getTeleportingToPos() != null) {
            allTeleportingLicowitchOnScreen.add(entityIn);
        }
    }

    protected void scale(LicowitchEntity entity, PoseStack poseStack, float partialTicks) {
        poseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    public boolean shouldRender(LicowitchEntity entity, Frustum camera, double x, double y, double z) {
        return super.m_5523_((Mob)entity, camera, x, y, z) || entity.getTeleportingToPos() != null;
    }

    public ResourceLocation getTextureLocation(LicowitchEntity entity) {
        return TEXTURE;
    }

    protected void setupRotations(LicowitchEntity licowitch, PoseStack poseStack, float f1, float f2, float f3) {
        super.m_7523_((LivingEntity)licowitch, poseStack, f1, f2, f3);
    }

    private class ItemLayer
    extends ItemInHandLayer<LicowitchEntity, LicowitchModel> {
        private final ItemInHandRenderer witchItemInHandRenderer;

        private ItemLayer(ItemInHandRenderer itemInHandRenderer) {
            super((RenderLayerParent)LicowitchRenderer.this, itemInHandRenderer);
            this.witchItemInHandRenderer = itemInHandRenderer;
        }

        protected void m_117184_(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext displayContext, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
            if (!itemStack.m_41619_() && livingEntity instanceof LicowitchEntity) {
                boolean flag;
                LicowitchEntity licowitch = (LicowitchEntity)livingEntity;
                float partialTicks = Minecraft.m_91087_().getPartialTick();
                boolean crossedArms = licowitch.areArmsVisuallyCrossed(partialTicks);
                boolean staff = itemStack.m_150930_((Item)ACItemRegistry.SUGAR_STAFF.get());
                poseStack.m_85836_();
                if (crossedArms) {
                    ((LicowitchModel)this.m_117386_()).translateToCrossedArms(humanoidArm, poseStack);
                } else {
                    ((LicowitchModel)this.m_117386_()).m_6002_(humanoidArm, poseStack);
                }
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                boolean bl = flag = humanoidArm == HumanoidArm.LEFT;
                if (crossedArms) {
                    poseStack.m_252880_(0.0f, 0.125f, -0.125f);
                } else {
                    poseStack.m_252880_((float)(flag ? 1 : -1) * 0.0325f, 0.125f, -0.125f);
                }
                if (staff) {
                    float forwardsBend = 0.0f;
                    if (licowitch.getAnimation() == LicowitchEntity.ANIMATION_SPELL_0) {
                        forwardsBend = 0.66f * ACMath.cullAnimationTick(licowitch.getAnimationTick(), 1.0f, LicowitchEntity.ANIMATION_SPELL_0, partialTicks, 18, 25);
                    }
                    if (licowitch.getAnimation() == LicowitchEntity.ANIMATION_SPELL_1) {
                        forwardsBend = 0.4f * ACMath.cullAnimationTick(licowitch.getAnimationTick(), 1.0f, LicowitchEntity.ANIMATION_SPELL_1, partialTicks, 25, 27);
                    }
                    if (crossedArms) {
                        poseStack.m_252880_(0.0f, 0.0f, 0.1f);
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(5.0f));
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(flag ? 20.0f : -20.0f));
                        poseStack.m_252880_(0.0f, 0.0f, -0.05f);
                    } else {
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(-2.5f));
                    }
                    poseStack.m_252880_(0.0f, -0.25f * forwardsBend, 0.0f);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(forwardsBend * -90.0f));
                } else {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(10.0f));
                }
                if (licowitch.getAnimation() == LicowitchEntity.ANIMATION_EAT) {
                    float animationIntensity = ACMath.cullAnimationTick(licowitch.getAnimationTick(), 4.0f, LicowitchEntity.ANIMATION_EAT, partialTicks, 0);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(animationIntensity * 30.0f));
                }
                this.witchItemInHandRenderer.m_269530_(livingEntity, itemStack, displayContext, flag, poseStack, multiBufferSource, packedLight);
                poseStack.m_85849_();
            }
        }
    }

    class TeleportingDoubleLayer
    extends RenderLayer<LicowitchEntity, LicowitchModel> {
        public TeleportingDoubleLayer() {
            super((RenderLayerParent)LicowitchRenderer.this);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, LicowitchEntity witch, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            Vec3 vec3;
            Vec3 to;
            float progress = witch.getTeleportingProgress(partialTicks);
            if (progress > 0.0f && (to = witch.getTeleportingToPos()) != null && (vec3 = to.m_82546_(witch.m_20318_(partialTicks))).m_82553_() > 0.5) {
                PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.PURPLE_WITCH_SHADER);
                VertexConsumer textureBuffer2 = bufferIn.m_6299_(RenderType.m_110470_((ResourceLocation)LicowitchRenderer.this.getTextureLocation(witch)));
                ((LicowitchModel)this.m_117386_()).m_7695_(poseStack, textureBuffer2, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)witch, (float)0.0f), 1.0f, 1.0f - progress, 1.0f, progress);
                VertexConsumer witchEffectBuffer2 = bufferIn.m_6299_(ACRenderTypes.getPurpleWitch(LicowitchRenderer.this.getTextureLocation(witch)));
                ((LicowitchModel)this.m_117386_()).m_7695_(poseStack, witchEffectBuffer2, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)witch, (float)0.0f), 1.0f, 0.0f, 1.0f, progress);
            }
        }
    }
}

