/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.conveyor;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorCacheData;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorModelRender;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.conveyor.BasicConveyorRender;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.RedstoneConveyor;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RedstoneConveyorRender
extends BasicConveyorRender<RedstoneConveyor> {
    public static final String MODEL_NAME = "conveyor_redstone_panel";
    public static DynamicModel MODEL_PANEL;
    private static final Map<Direction, BakedModel> ROTATED_MODELS;

    @Override
    public void updateCachedModels(ModelBaker baker, Function<Material, TextureAtlasSprite> getTexture) {
        ResourceLocation modelName = MODEL_PANEL.getName();
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            BlockModelRotation transform = BlockModelRotation.m_119153_((int)0, (int)((int)d.m_122435_() + 180));
            ROTATED_MODELS.put(d, baker.bake(modelName, (ModelState)transform, getTexture));
        }
    }

    public RedstoneConveyorRender(ResourceLocation active, ResourceLocation inactive) {
        super(active, inactive);
    }

    @Override
    public Object getModelCacheKey(IConveyorModelRender.RenderContext<RedstoneConveyor> context) {
        BasicConveyorCacheData basic = IConveyorModelRender.getDefaultData(this, context);
        RedstoneConveyor instance = context.instance();
        if (instance == null) {
            return basic;
        }
        return Pair.of((Object)basic, (Object)instance.isPanelRight());
    }

    @Override
    public boolean shouldRenderWall(Direction facing, ConveyorWall wall, IConveyorModelRender.RenderContext<RedstoneConveyor> context) {
        RedstoneConveyor instance = context.instance();
        if (instance == null || instance.isPanelRight() && wall == ConveyorWall.RIGHT || !instance.isPanelRight() && wall == ConveyorWall.LEFT) {
            return true;
        }
        return super.shouldRenderWall(facing, wall, context);
    }

    @Override
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, IConveyorModelRender.RenderContext<RedstoneConveyor> context, @Nullable RenderType renderType) {
        if (renderType != null && renderType != RenderType.m_110463_()) {
            return super.modifyQuads(baseModel, context, renderType);
        }
        boolean panelRight = context.instance() == null || context.instance().isPanelRight();
        Direction facing = context.getFacing();
        BakedModel model = ROTATED_MODELS.get(panelRight ? facing : facing.m_122424_());
        if (model != null) {
            String[] stringArray;
            if (context.isActiveOr(false)) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "panel";
                stringArray = stringArray2;
                stringArray2[1] = "lamp";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "panel";
            }
            String[] parts = stringArray;
            baseModel.addAll(model.getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), IEProperties.VisibilityList.show(parts)), null));
        }
        return baseModel;
    }

    static {
        ROTATED_MODELS = new EnumMap<Direction, BakedModel>(Direction.class);
    }
}

