/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.config.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public record ConfigCodec(boolean modEnabled, Legacy legacyModule, Features featuresModule, Experimental experimentalModule) {
    public static final Codec<ConfigCodec> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("mod_enabled").orElse((Object)true).forGetter(ConfigCodec::modEnabled), (App)Legacy.CODEC.fieldOf("legacy").orElse((Object)Legacy.DEFAULT).forGetter(ConfigCodec::legacyModule), (App)Features.CODEC.fieldOf("features").orElse((Object)Features.DEFAULT).forGetter(ConfigCodec::featuresModule), (App)Experimental.CODEC.fieldOf("experimental").orElse((Object)Experimental.DEFAULT).forGetter(ConfigCodec::experimentalModule)).apply((Applicative)instance, ConfigCodec::new));

    private List<String> getEnabledPacks(boolean terralithEnabled) {
        ArrayList<String> enabledPacks = new ArrayList<String>();
        if (this.modEnabled()) {
            if (this.legacyModule().enabled()) {
                enabledPacks.add("legacy");
            }
            if (this.experimentalModule().increasedHeight()) {
                enabledPacks.add(terralithEnabled ? "increased_height_terratonic" : "increased_height");
            }
            enabledPacks.add(terralithEnabled ? "terratonic" : "tectonic");
        }
        return enabledPacks;
    }

    public void enablePacks(boolean terralithEnabled, Consumer<String> registerPack) {
        for (String packName : ConfigHandler.getConfig().getEnabledPacks(terralithEnabled)) {
            registerPack.accept(packName);
        }
    }

    public double getValue(String option) {
        return switch (option) {
            case "terrain_scale" -> this.experimentalModule().terrainScale();
            case "horizontal_mountain_scale" -> this.experimentalModule().horizontalMountainScale();
            case "deeper_oceans" -> {
                if (this.featuresModule().deeperOceans()) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case "desert_dunes" -> {
                if (this.featuresModule().desertDunes()) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case "lava_rivers" -> {
                if (this.featuresModule().lavaRivers()) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case "underground_rivers" -> {
                if (this.featuresModule().undergroundRivers()) {
                    yield 1.0;
                }
                yield 0.0;
            }
            default -> 0.0;
        };
    }

    public record Legacy(String commentA, String commentB, String commentC, boolean enabled) {
        private static final String COMMENT_A = "Tectonic v1 worlds have old biome data preventing them from being opened in Tectonic v2.1+.";
        private static final String COMMENT_B = "Enabling legacy mode will add back the biomes and upgrade worlds to the new format upon opening them.";
        private static final String COMMENT_C = "Once a world is upgraded by opening it, turn off legacy mode.";
        public static final Codec<Legacy> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("__A").orElse((Object)COMMENT_A).forGetter(Legacy::commentA), (App)Codec.STRING.fieldOf("__B").orElse((Object)COMMENT_B).forGetter(Legacy::commentB), (App)Codec.STRING.fieldOf("__C").orElse((Object)COMMENT_C).forGetter(Legacy::commentC), (App)Codec.BOOL.fieldOf("enabled").orElse((Object)false).forGetter(Legacy::enabled)).apply((Applicative)instance, Legacy::new));
        public static final Legacy DEFAULT = new Legacy("Tectonic v1 worlds have old biome data preventing them from being opened in Tectonic v2.1+.", "Enabling legacy mode will add back the biomes and upgrade worlds to the new format upon opening them.", "Once a world is upgraded by opening it, turn off legacy mode.", false);
    }

    public record Features(String commentA, String commentB, boolean deeperOceans, boolean desertDunes, boolean lavaRivers, int snowStartOffset, boolean undergroundRivers) {
        private static final String COMMENT_A = "Enabling deeper oceans will lower vanilla ocean monuments to compensate for lower depth.";
        private static final String COMMENT_B = "Snow start offset moves where snow starts, preventing biomes like Taigas looking weird next to mountain ranges.";
        public static final Codec<Features> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("__A").orElse((Object)COMMENT_A).forGetter(Features::commentA), (App)Codec.STRING.fieldOf("__B").orElse((Object)COMMENT_B).forGetter(Features::commentB), (App)Codec.BOOL.fieldOf("deeper_oceans").orElse((Object)true).forGetter(Features::deeperOceans), (App)Codec.BOOL.fieldOf("desert_dunes").orElse((Object)true).forGetter(Features::desertDunes), (App)Codec.BOOL.fieldOf("lava_rivers").orElse((Object)true).forGetter(Features::lavaRivers), (App)Codec.INT.fieldOf("snow_start_offset").orElse((Object)128).forGetter(Features::snowStartOffset), (App)Codec.BOOL.fieldOf("underground_rivers").orElse((Object)true).forGetter(Features::undergroundRivers)).apply((Applicative)instance, Features::new));
        public static final Features DEFAULT = new Features("Enabling deeper oceans will lower vanilla ocean monuments to compensate for lower depth.", "Snow start offset moves where snow starts, preventing biomes like Taigas looking weird next to mountain ranges.", true, true, true, 128, true);
    }

    public record Experimental(String commentA, String commentB, String commentC, String commentD, boolean increasedHeight, double horizontalMountainScale, double terrainScale) {
        private static final String COMMENT_A = "The increased height setting will change the max Overworld build and generation height to y640.";
        private static final String COMMENT_B = "The horizontal mountain scale setting will change the thickness of mountain ranges and the spacing between them.";
        private static final String COMMENT_C = "Lower values = thicker mountain ranges and more space between ranges. 0.15-0.25 is the sweet spot.";
        private static final String COMMENT_D = "The terrain scale setting will vertically stretch/compress terrain. Higher values = more extreme terrain heights.";
        public static final Codec<Experimental> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("__A").orElse((Object)COMMENT_A).forGetter(Experimental::commentA), (App)Codec.STRING.fieldOf("__B").orElse((Object)COMMENT_B).forGetter(Experimental::commentB), (App)Codec.STRING.fieldOf("__C").orElse((Object)COMMENT_C).forGetter(Experimental::commentC), (App)Codec.STRING.fieldOf("__D").orElse((Object)COMMENT_D).forGetter(Experimental::commentD), (App)Codec.BOOL.fieldOf("increased_height").orElse((Object)false).forGetter(Experimental::increasedHeight), (App)Codec.DOUBLE.fieldOf("horizontal_mountain_scale").orElse((Object)0.25).forGetter(Experimental::horizontalMountainScale), (App)Codec.DOUBLE.fieldOf("terrain_scale").orElse((Object)1.125).forGetter(Experimental::terrainScale)).apply((Applicative)instance, Experimental::new));
        public static final Experimental DEFAULT = new Experimental("The increased height setting will change the max Overworld build and generation height to y640.", "The horizontal mountain scale setting will change the thickness of mountain ranges and the spacing between them.", "Lower values = thicker mountain ranges and more space between ranges. 0.15-0.25 is the sweet spot.", "The terrain scale setting will vertically stretch/compress terrain. Higher values = more extreme terrain heights.", false, 0.25, 1.125);
    }
}

