/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.util;

import com.github.nyuppo.config.Variants;
import com.github.nyuppo.variant.MobVariant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;

public class VariantBag {
    private List<Entry> entries = new ArrayList<Entry>();
    private double accumulatedWeight;
    private final EntityType<?> mob;

    public VariantBag(EntityType<?> mob, List<MobVariant> variants) {
        this.mob = mob;
        for (MobVariant variant : variants) {
            this.addEntry(variant);
        }
    }

    public void addEntry(MobVariant variant) {
        this.accumulatedWeight += (double)variant.getWeight();
        Entry e = new Entry();
        e.variant = variant;
        e.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e);
    }

    public MobVariant getRandomEntry(RandomSource random) {
        double r = random.m_188500_() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r)) continue;
            return entry.variant;
        }
        return Variants.getDefaultVariant(this.mob);
    }

    private class Entry {
        double accumulatedWeight;
        MobVariant variant;

        private Entry() {
        }
    }
}

