/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryHelper {
    public static ItemStack removeItem(IItemHandlerModifiable handler, int slot, int amount) {
        if (slot >= 0 && slot < handler.getSlots() && !handler.getStackInSlot(slot).m_41619_() && amount > 0) {
            ItemStack currentStack = handler.getStackInSlot(slot).m_41777_();
            ItemStack stackAtPointer = currentStack.m_41777_();
            currentStack.m_41620_(amount);
            handler.setStackInSlot(slot, currentStack);
            return stackAtPointer;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeItemShiftClick(IItemHandlerModifiable handler, int slot, int amount) {
        if (slot >= 0 && slot < handler.getSlots() && !handler.getStackInSlot(slot).m_41619_() && amount > 0) {
            ItemStack currentStack = handler.getStackInSlot(slot);
            currentStack.m_41620_(amount);
            handler.setStackInSlot(slot, currentStack);
            return handler.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack takeItem(IItemHandler handler, int slot) {
        return slot >= 0 && slot < handler.getSlots() ? handler.insertItem(slot, ItemStack.f_41583_, false) : ItemStack.f_41583_;
    }

    public static boolean isEmpty(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static void iterateHandler(IItemHandler handler, BiConsumer<Integer, ItemStack> consumer) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            consumer.accept(i, stack);
        }
    }

    public static boolean iterate(ItemStackHandler handler, BiFunction<Integer, ItemStack, Boolean> function) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            boolean matches = function.apply(i, handler.getStackInSlot(i).m_41777_());
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public static ItemStack addItemStackToHandler(IItemHandlerModifiable handler, ItemStack stack, boolean simulate) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    public static ItemStack extractFromBackpack(IItemHandlerModifiable handler, ItemStack stack, int amount, boolean simulate) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)handler.getStackInSlot(i))) continue;
            return handler.extractItem(i, amount, simulate);
        }
        return ItemStack.f_41583_;
    }
}

