/*
 * Decompiled with CFR 0.152.
 */
package net.jojosolos.flightconduit.event;

import net.jojosolos.flightconduit.Config;
import net.jojosolos.flightconduit.effect.ModEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="flightconduit")
public class ModEvents {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onFlightConduitEffectEnds(MobEffectEvent.Expired event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_7500_() && !player.m_5833_() && event.getEffectInstance().m_19544_() == ModEffects.FLIGHT.get()) {
            double distanceToGround;
            player.m_150110_().f_35936_ = false;
            player.m_150110_().f_35935_ = false;
            player.m_6885_();
            boolean shouldApplyFeatherFalling = true;
            if (!Config.featherFallingApplyNearGround && (distanceToGround = ModEvents.getDistanceToGround(player)) <= (double)Config.featherFallingNearGroundBlocks) {
                shouldApplyFeatherFalling = false;
            }
            if (shouldApplyFeatherFalling) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, Config.featherFallingDuration, 1));
            }
        }
    }

    private static double getDistanceToGround(Player player) {
        Level level = player.m_9236_();
        BlockPos playerPos = player.m_20183_();
        int searchDistance = Config.featherFallingNearGroundBlocks + 10;
        for (int i = 0; i < searchDistance; ++i) {
            BlockPos checkPos = playerPos.m_6625_(i);
            if (checkPos.m_123342_() < level.m_141937_()) {
                return playerPos.m_123342_() - level.m_141937_();
            }
            if (level.m_8055_(checkPos).m_60795_() || !level.m_8055_(checkPos).m_60804_((BlockGetter)level, checkPos)) continue;
            return i;
        }
        return searchDistance + 10;
    }
}

