/*
 * Decompiled with CFR 0.152.
 */
package net.jojosolos.flightconduit.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.jojosolos.flightconduit.Config;
import net.jojosolos.flightconduit.block.entity.ModBlockEntities;
import net.jojosolos.flightconduit.effect.ModEffects;
import net.jojosolos.flightconduit.particle.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FlightConduitBlockEntity
extends BlockEntity {
    public int tickCount;
    private float activeRotation;
    private boolean isActive;
    private boolean isHunting;
    private final List<BlockPos> effectBlocks = Lists.newArrayList();
    @Nullable
    private LivingEntity destroyTarget;
    @Nullable
    private UUID destroyTargetUUID;
    private long nextAmbientSoundActivation;

    public FlightConduitBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FLIGHT_CONDUIT_BE.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.destroyTargetUUID = pTag.m_128403_("Target") ? pTag.m_128342_("Target") : null;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.destroyTarget != null) {
            pTag.m_128362_("Target", this.destroyTarget.m_20148_());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void clientTick(Level pLevel, BlockPos pPos, BlockState pState, FlightConduitBlockEntity pBlockEntity) {
        ++pBlockEntity.tickCount;
        long i = pLevel.m_46467_();
        List<BlockPos> list = pBlockEntity.effectBlocks;
        if (i % 40L == 0L) {
            pBlockEntity.isActive = FlightConduitBlockEntity.updateShape(pLevel, pPos, list);
            FlightConduitBlockEntity.updateHunting(pBlockEntity, list);
        }
        FlightConduitBlockEntity.updateClientTarget(pLevel, pPos, pBlockEntity);
        FlightConduitBlockEntity.animationTick(pLevel, pPos, list, (Entity)pBlockEntity.destroyTarget, pBlockEntity.tickCount);
        if (pBlockEntity.isActive()) {
            pBlockEntity.activeRotation += 1.0f;
        }
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, FlightConduitBlockEntity pBlockEntity) {
        ++pBlockEntity.tickCount;
        long i = pLevel.m_46467_();
        List<BlockPos> list = pBlockEntity.effectBlocks;
        if (i % (long)Config.flightCheckInterval == 0L) {
            boolean flag = FlightConduitBlockEntity.updateShape(pLevel, pPos, list);
            if (flag != pBlockEntity.isActive) {
                SoundEvent soundevent = flag ? SoundEvents.f_11767_ : SoundEvents.f_11824_;
                pLevel.m_5594_((Player)null, pPos, soundevent, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            pBlockEntity.isActive = flag;
            FlightConduitBlockEntity.updateHunting(pBlockEntity, list);
            if (flag) {
                FlightConduitBlockEntity.applyEffects(pLevel, pPos, list);
                FlightConduitBlockEntity.updateDestroyTarget(pLevel, pPos, pState, list, pBlockEntity);
            }
        }
        if (pBlockEntity.isActive()) {
            if (i % 80L == 0L) {
                pLevel.m_5594_((Player)null, pPos, SoundEvents.f_11768_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            if (i > pBlockEntity.nextAmbientSoundActivation) {
                pBlockEntity.nextAmbientSoundActivation = i + 60L + (long)pLevel.m_213780_().m_188503_(40);
                pLevel.m_5594_((Player)null, pPos, SoundEvents.f_11822_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
    }

    private static void updateHunting(FlightConduitBlockEntity pBlockEntity, List<BlockPos> pPositions) {
        pBlockEntity.setHunting(pPositions.size() >= 42);
    }

    private static boolean updateShape(Level pLevel, BlockPos pPos, List<BlockPos> pPositions) {
        pPositions.clear();
        for (int j1 = -2; j1 <= 2; ++j1) {
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    BlockPos blockpos1;
                    BlockState blockstate;
                    int i2 = Math.abs(j1);
                    int l = Math.abs(k1);
                    int i1 = Math.abs(l1);
                    if (i2 <= 1 && l <= 1 && i1 <= 1 || (j1 != 0 || l != 2 && i1 != 2) && (k1 != 0 || i2 != 2 && i1 != 2) && (l1 != 0 || i2 != 2 && l != 2) || !FlightConduitBlockEntity.isFlightConduitFrame(blockstate = pLevel.m_8055_(blockpos1 = pPos.m_7918_(j1, k1, l1)), (LevelReader)pLevel, blockpos1, pPos)) continue;
                    pPositions.add(blockpos1);
                }
            }
        }
        return pPositions.size() >= 16;
    }

    private static boolean isFlightConduitFrame(BlockState state, LevelReader level, BlockPos pos, BlockPos conduit) {
        for (Block block : Config.blocks) {
            if (state.m_60734_() != block) continue;
            return true;
        }
        return false;
    }

    private static void applyEffects(Level pLevel, BlockPos pPos, List<BlockPos> pPositions) {
        int i1;
        int l;
        int i = pPositions.size();
        int j = (int)((double)(i / 7 * 10) * Config.rangeMultiplier);
        int k = pPos.m_123341_();
        AABB aabb = new AABB((double)k, (double)(l = pPos.m_123342_()), (double)(i1 = pPos.m_123343_()), (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).m_82400_((double)j).m_82363_(0.0, (double)pLevel.m_141928_(), 0.0);
        List list = pLevel.m_45976_(Player.class, aabb);
        if (!list.isEmpty()) {
            for (Player player : list) {
                if (!pPos.m_123314_((Vec3i)player.m_20183_(), (double)j)) continue;
                player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FLIGHT.get(), Config.flightEffectDuration, 0, true, false, true));
            }
        }
    }

    private static void updateDestroyTarget(Level pLevel, BlockPos pPos, BlockState pState, List<BlockPos> pPositions, FlightConduitBlockEntity pBlockEntity) {
        LivingEntity livingentity = pBlockEntity.destroyTarget;
        int i = pPositions.size();
        if (i < 42) {
            pBlockEntity.destroyTarget = null;
        } else if (pBlockEntity.destroyTarget == null && pBlockEntity.destroyTargetUUID != null) {
            pBlockEntity.destroyTarget = FlightConduitBlockEntity.findDestroyTarget(pLevel, pPos, pBlockEntity.destroyTargetUUID);
            pBlockEntity.destroyTargetUUID = null;
        } else if (pBlockEntity.destroyTarget == null) {
            List list = pLevel.m_6443_(LivingEntity.class, FlightConduitBlockEntity.getDestroyRangeAABB(pPos), p_289511_ -> p_289511_ instanceof Phantom);
            if (!list.isEmpty()) {
                pBlockEntity.destroyTarget = (LivingEntity)list.get(pLevel.f_46441_.m_188503_(list.size()));
            }
        } else if (!pBlockEntity.destroyTarget.m_6084_() || !pPos.m_123314_((Vec3i)pBlockEntity.destroyTarget.m_20183_(), 8.0)) {
            pBlockEntity.destroyTarget = null;
        }
        if (pBlockEntity.destroyTarget != null) {
            pLevel.m_6263_((Player)null, pBlockEntity.destroyTarget.m_20185_(), pBlockEntity.destroyTarget.m_20186_(), pBlockEntity.destroyTarget.m_20189_(), SoundEvents.f_11823_, SoundSource.BLOCKS, 1.0f, 1.0f);
            pBlockEntity.destroyTarget.m_6469_(pLevel.m_269111_().m_269425_(), 4.0f);
        }
        if (livingentity != pBlockEntity.destroyTarget) {
            pLevel.m_7260_(pPos, pState, pState, 2);
        }
    }

    private static void updateClientTarget(Level pLevel, BlockPos pPos, FlightConduitBlockEntity pBlockEntity) {
        if (pBlockEntity.destroyTargetUUID == null) {
            pBlockEntity.destroyTarget = null;
        } else if (pBlockEntity.destroyTarget == null || !pBlockEntity.destroyTarget.m_20148_().equals(pBlockEntity.destroyTargetUUID)) {
            pBlockEntity.destroyTarget = FlightConduitBlockEntity.findDestroyTarget(pLevel, pPos, pBlockEntity.destroyTargetUUID);
            if (pBlockEntity.destroyTarget == null) {
                pBlockEntity.destroyTargetUUID = null;
            }
        }
    }

    private static AABB getDestroyRangeAABB(BlockPos pPos) {
        int i = pPos.m_123341_();
        int j = pPos.m_123342_();
        int k = pPos.m_123343_();
        return new AABB((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1)).m_82400_(20.0);
    }

    @Nullable
    private static LivingEntity findDestroyTarget(Level pLevel, BlockPos pPos, UUID pTargetId) {
        List list = pLevel.m_6443_(LivingEntity.class, FlightConduitBlockEntity.getDestroyRangeAABB(pPos), p_289510_ -> p_289510_.m_20148_().equals(pTargetId));
        return list.size() == 1 ? (LivingEntity)list.get(0) : null;
    }

    private static void animationTick(Level pLevel, BlockPos pPos, List<BlockPos> pPositions, @Nullable Entity pEntity, int pTickCount) {
        RandomSource randomsource = pLevel.f_46441_;
        double d0 = Mth.m_14031_((float)((float)(pTickCount + 35) * 0.1f)) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vec3 vec3 = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 1.5 + d0, (double)pPos.m_123343_() + 0.5);
        for (BlockPos blockpos : pPositions) {
            if (randomsource.m_188503_(50) != 0) continue;
            BlockPos blockpos1 = blockpos.m_121996_((Vec3i)pPos);
            float f = -0.5f + randomsource.m_188501_() + (float)blockpos1.m_123341_();
            float f1 = -2.0f + randomsource.m_188501_() + (float)blockpos1.m_123342_();
            float f2 = -0.5f + randomsource.m_188501_() + (float)blockpos1.m_123343_();
            pLevel.m_7106_((ParticleOptions)ModParticles.FLIGHT_CONDUIT_PARTICLE.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)f, (double)f1, (double)f2);
        }
        if (pEntity != null) {
            Vec3 vec31 = new Vec3(pEntity.m_20185_(), pEntity.m_20188_(), pEntity.m_20189_());
            float f3 = (-0.5f + randomsource.m_188501_()) * (3.0f + pEntity.m_20205_());
            float f4 = -1.0f + randomsource.m_188501_() * pEntity.m_20206_();
            float f5 = (-0.5f + randomsource.m_188501_()) * (3.0f + pEntity.m_20205_());
            Vec3 vec32 = new Vec3((double)f3, (double)f4, (double)f5);
            pLevel.m_7106_((ParticleOptions)ModParticles.FLIGHT_CONDUIT_PARTICLE.get(), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isHunting() {
        return this.isHunting;
    }

    private void setHunting(boolean pIsHunting) {
        this.isHunting = pIsHunting;
    }

    public float getActiveRotation(float pPartialTick) {
        return (this.activeRotation + pPartialTick) * -0.0375f;
    }
}

