/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.misc;

import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.util.ChunkManager;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IDataStorage;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.owner.TurtlePeripheralOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/ChunkVialPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/owner/TurtlePeripheralOwner;", "peripheralOwner", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/owner/TurtlePeripheralOwner;)V", "loadedChunk", "Lnet/minecraft/world/level/ChunkPos;", "isEnabled", "", "()Z", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "chunkPos", "getChunkPos", "()Lnet/minecraft/world/level/ChunkPos;", "updateChunkState", "", "setLoadedChunk", "newChunk", "manager", "Lsite/siredvin/turtlematic/util/ChunkManager;", "level", "Lnet/minecraft/server/level/ServerLevel;", "detach", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "Companion", "turtlematic-forge-1.20.1"})
public final class ChunkVialPeripheral
extends OwnedPeripheral<TurtlePeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ChunkPos loadedChunk;
    @NotNull
    private static final String type = "chunk_vial";
    @NotNull
    private static final String UUID_TAG = "uuid";

    public ChunkVialPeripheral(@NotNull TurtlePeripheralOwner peripheralOwner) {
        Intrinsics.checkNotNullParameter((Object)peripheralOwner, (String)"peripheralOwner");
        super(type, (IPeripheralOwner)peripheralOwner);
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnableChunkVial();
    }

    private final UUID getUuid() {
        IDataStorage storage = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getDataStorage();
        if (!storage.has(UUID_TAG)) {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            storage.putUUID(UUID_TAG, uUID);
        }
        return storage.getUUID(UUID_TAG);
    }

    private final ChunkPos getChunkPos() {
        Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        ChunkPos chunkPos = level.m_46865_(((TurtlePeripheralOwner)this.getPeripheralOwner()).getPos()).m_7697_();
        Intrinsics.checkNotNullExpressionValue((Object)chunkPos, (String)"getPos(...)");
        return chunkPos;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void updateChunkState() {
        Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        ChunkManager manager = ChunkManager.Companion.get(level2);
        if (this.loadedChunk != null) {
            ChunkPos chunkPos = this.loadedChunk;
            Intrinsics.checkNotNull((Object)chunkPos);
            if (Intrinsics.areEqual((Object)chunkPos, (Object)this.getChunkPos())) {
                manager.touch(this.getUuid());
                return;
            }
        }
        this.setLoadedChunk(this.getChunkPos(), manager, level2);
    }

    private final void setLoadedChunk(ChunkPos newChunk, ChunkManager manager, ServerLevel level) {
        if (this.loadedChunk != null) {
            ChunkManager.removeForceChunk$default(manager, level, this.getUuid(), null, 4, null);
            this.loadedChunk = null;
        }
        if (newChunk != null) {
            this.loadedChunk = newChunk;
            UUID uUID = this.getUuid();
            ChunkPos chunkPos = this.loadedChunk;
            Intrinsics.checkNotNull((Object)chunkPos);
            manager.addForceChunk(level, uUID, chunkPos);
        }
    }

    public void detach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        super.detach(computer);
        Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        ChunkManager manager = ChunkManager.Companion.get(level2);
        this.setLoadedChunk(null, manager, level2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/ChunkVialPeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "<init>", "()V", "type", "", "getType", "()Ljava/lang/String;", "UUID_TAG", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getType() {
            return type;
        }

        @Override
        @NotNull
        public ResourceLocation getUpgradeID() {
            return PeripheralConfiguration.DefaultImpls.getUpgradeID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

