/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.forged;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.broccolium.modules.platform.api.InnerPlatformToolkit;
import site.siredvin.broccolium.modules.storage.item.ContainerUtils;
import site.siredvin.broccolium.modules.storage.item.FakeItemContainer;
import site.siredvin.broccolium.modules.storage.item.LimitedInventory;
import site.siredvin.turtlematic.api.IAutomataCoreTier;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.computercraft.operations.CountOperation;
import site.siredvin.turtlematic.computercraft.operations.SingleOperation;
import site.siredvin.turtlematic.computercraft.operations.SingleOperationContext;
import site.siredvin.turtlematic.computercraft.peripheral.automatas.BaseAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.peripheral.forged.ExperienceAutomataCorePeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralFunction;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOperation;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.api.TransformInteractionMode;
import site.siredvin.tweakium.modules.peripheral.api.VerticalDirection;
import site.siredvin.tweakium.modules.peripheral.boon.ExperienceBoon;
import site.siredvin.tweakium.modules.peripheral.boon.PeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.tweakium.modules.player.FakePlayerProxy;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J.\u0010\u0013\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0007J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006!"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/SmithingAutomataCorePeripheral;", "Lsite/siredvin/turtlematic/computercraft/peripheral/forged/ExperienceAutomataCorePeripheral;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "tier", "Lsite/siredvin/turtlematic/api/IAutomataCoreTier;", "<init>", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;Lsite/siredvin/turtlematic/api/IAutomataCoreTier;)V", "isEnabled", "", "()Z", "possibleOperations", "", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOperation;", "isEditable", "pos", "Lnet/minecraft/core/BlockPos;", "findBlock", "Lkotlin/Pair;", "Lnet/minecraft/world/phys/BlockHitResult;", "Lnet/minecraft/world/level/block/state/BlockState;", "Ldan200/computercraft/api/lua/MethodResult;", "overwrittenDirection", "Lsite/siredvin/tweakium/modules/peripheral/api/VerticalDirection;", "smeltItem", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "smeltBlock", "smith", "smelt", "Companion", "turtlematic-forge-1.20.1"})
public final class SmithingAutomataCorePeripheral
extends ExperienceAutomataCorePeripheral {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String type = "smithingAutomata";

    public SmithingAutomataCorePeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side, @NotNull IAutomataCoreTier tier) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        super(type, turtle, side, tier);
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnableSmithingAutomataCore();
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> possibleOperations() {
        List<IPeripheralOperation<?>> base = super.possibleOperations();
        base.add(SingleOperation.SMITH);
        base.add(CountOperation.SMELT);
        return base;
    }

    private final boolean isEditable(BlockPos pos) {
        return (Boolean)IPeripheralOwner.DefaultImpls.withPlayer$default((IPeripheralOwner)this.getPeripheralOwner(), arg_0 -> SmithingAutomataCorePeripheral.isEditable$lambda$0(pos, arg_0), null, (boolean)false, (int)6, null) == false;
    }

    private final Pair<Pair<BlockHitResult, BlockState>, MethodResult> findBlock(VerticalDirection overwrittenDirection) {
        VerticalDirection verticalDirection = overwrittenDirection;
        BlockHitResult blockHitResult = (BlockHitResult)IPeripheralOwner.DefaultImpls.withPlayer$default((IPeripheralOwner)this.getPeripheralOwner(), SmithingAutomataCorePeripheral::findBlock$lambda$1, (Direction)(verticalDirection != null ? verticalDirection.getMinecraftDirection() : null), (boolean)false, (int)4, null);
        if (blockHitResult == null) {
            Object[] objectArray = new Object[]{null, "There is nothing to work with"};
            return new Pair(null, (Object)MethodResult.of((Object[])objectArray));
        }
        BlockHitResult hit = blockHitResult;
        Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        BlockState blockState = level.m_8055_(hit.m_82425_());
        if (blockState.m_60795_()) {
            Object[] objectArray = new Object[]{null, "There is nothing to work with"};
            return new Pair(null, (Object)MethodResult.of((Object[])objectArray));
        }
        BlockPos blockPos = hit.m_82425_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        if (!this.isEditable(blockPos)) {
            Object[] objectArray = new Object[]{null, "This block is protected"};
            return new Pair(null, (Object)MethodResult.of((Object[])objectArray));
        }
        return new Pair((Object)new Pair((Object)hit, (Object)blockState), null);
    }

    private final MethodResult smeltItem(IArguments arguments) {
        MethodResult methodResult;
        Container container = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
        Container turtleInventory = container;
        int[] nArray = new int[]{((TurtlePeripheralOwner)this.getPeripheralOwner()).getTurtle().getSelectedSlot()};
        LimitedInventory limitedInventory = new LimitedInventory(turtleInventory, nArray);
        int limit = arguments.optInt(1, Integer.MAX_VALUE);
        int smeltCount = Math.min(limit, limitedInventory.m_8020_(0).m_41613_());
        Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        Optional optional = level2.m_7465_().m_44015_(RecipeType.f_44108_, (Container)limitedInventory, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRecipeFor(...)");
        Optional optRecipe = optional;
        if (!optRecipe.isPresent()) {
            Object[] objectArray = new Object[]{null, "Cannot find smelting recipe"};
            MethodResult methodResult2 = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNull((Object)methodResult2);
            methodResult = methodResult2;
        } else {
            methodResult = this.withOperation(CountOperation.SMELT, smeltCount, arg_0 -> SmithingAutomataCorePeripheral.smeltItem$lambda$2(this, smeltCount, optRecipe, limitedInventory, turtleInventory, level2, arg_0), null);
        }
        return methodResult;
    }

    private final MethodResult smeltBlock(IArguments arguments) {
        VerticalDirection verticalDirection;
        Optional directionArgument = arguments.optString(1);
        if (directionArgument.isEmpty()) {
            verticalDirection = null;
        } else {
            Object t = directionArgument.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            verticalDirection = VerticalDirection.Companion.luaValueOf((String)t);
        }
        VerticalDirection overwrittenDirection = verticalDirection;
        Pair<Pair<BlockHitResult, BlockState>, MethodResult> blockSearchResult = this.findBlock(overwrittenDirection);
        if (blockSearchResult.getSecond() != null) {
            Object object = blockSearchResult.getSecond();
            Intrinsics.checkNotNull((Object)object);
            return (MethodResult)object;
        }
        Object object = blockSearchResult.getFirst();
        Intrinsics.checkNotNull((Object)object);
        BlockState blockState = (BlockState)((Pair)object).getSecond();
        Object object2 = blockSearchResult.getFirst();
        Intrinsics.checkNotNull((Object)object2);
        BlockHitResult hit = (BlockHitResult)((Pair)object2).getFirst();
        Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        ItemStack itemStack = blockState.m_60734_().m_5456_().m_7968_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
        FakeItemContainer fakeContainer = new FakeItemContainer(itemStack);
        Optional optRecipe = level2.m_7465_().m_44015_(RecipeType.f_44108_, (Container)fakeContainer, level2);
        if (optRecipe.isEmpty()) {
            Object[] objectArray = new Object[]{null, "Cannot perform in-place smelting for this block"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        return BaseAutomataCorePeripheral.withOperation$default(this, CountOperation.SMELT, 1, arg_0 -> SmithingAutomataCorePeripheral.smeltBlock$lambda$3(optRecipe, level2, hit, this, arg_0), null, 8, null);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult smith() throws LuaException {
        return this.withOperation(SingleOperation.SMITH, (IPeripheralFunction<SingleOperationContext, MethodResult>)((IPeripheralFunction)arg_0 -> SmithingAutomataCorePeripheral.smith$lambda$4(this, arg_0)));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult smelt(@NotNull IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String string = arguments.getString(0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return switch (WhenMappings.$EnumSwitchMapping$0[TransformInteractionMode.Companion.luaValueOf(string).ordinal()]) {
            case 1 -> this.smeltBlock(arguments);
            case 2 -> this.smeltItem(arguments);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean isEditable$lambda$0(BlockPos $pos, FakePlayerProxy it) {
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        InnerPlatformToolkit innerPlatformToolkit = PlatformToolkit.INSTANCE.get();
        BlockState blockState = it.getFakePlayer().m_9236_().m_8055_($pos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        return innerPlatformToolkit.isBlockProtected($pos, blockState, it.getFakePlayer());
    }

    private static final BlockHitResult findBlock$lambda$1(FakePlayerProxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HitResult hit = it.findHit(true, false);
        if (!(hit instanceof BlockHitResult)) {
            return null;
        }
        return (BlockHitResult)hit;
    }

    private static final MethodResult smeltItem$lambda$2(SmithingAutomataCorePeripheral this$0, int $smeltCount, Optional $optRecipe, LimitedInventory $limitedInventory, Container $turtleInventory, Level $level, int it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$optRecipe, (String)"$optRecipe");
        Intrinsics.checkNotNullParameter((Object)$limitedInventory, (String)"$limitedInventory");
        Intrinsics.checkNotNullParameter((Object)$turtleInventory, (String)"$turtleInventory");
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        this$0.addRotationCycle($smeltCount / 2);
        Object t = $optRecipe.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        SmeltingRecipe recipe = (SmeltingRecipe)t;
        ItemStack itemStack = recipe.m_5874_((Container)$limitedInventory, (RegistryAccess)RegistryAccess.f_243945_);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"assemble(...)");
        ItemStack result = itemStack;
        result.m_41764_(result.m_41613_() * $smeltCount);
        $limitedInventory.reduceCount(0, $smeltCount);
        int n = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        BlockPos blockPos = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getPos().m_121945_(((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getFacing());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
        ContainerUtils.INSTANCE.toInventoryOrToWorld(result, $turtleInventory, n, blockPos, $level);
        ExperienceBoon experienceBoon = (ExperienceBoon)((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getBoon((IPeripheralOwnerBoonKey)PeripheralOwnerBoonKey.Companion.getEXPERIENCE());
        if (experienceBoon != null) {
            experienceBoon.adjustStoredXP((double)((float)$smeltCount * recipe.m_43750_()));
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final MethodResult smeltBlock$lambda$3(Optional $optRecipe, Level $level, BlockHitResult $hit, SmithingAutomataCorePeripheral this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$hit, (String)"$hit");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object t = $optRecipe.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        SmeltingRecipe recipe = (SmeltingRecipe)t;
        ItemStack recipeResult = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        if (recipeResult.m_41720_() instanceof BlockItem && recipeResult.m_41613_() == 1) {
            Item item = recipeResult.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BlockItem");
            BlockState targetBlockState = ((BlockItem)item).m_40614_().m_49966_();
            $level.m_46597_($hit.m_82425_(), targetBlockState);
        } else {
            $level.m_46597_($hit.m_82425_(), Blocks.f_50016_.m_49966_());
            ItemStack itemStack = recipeResult.m_41777_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
            int n = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
            BlockPos blockPos = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getPos().m_121945_(((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getFacing());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
            ContainerUtils.INSTANCE.toInventoryOrToWorld(itemStack, container, n, blockPos, $level);
        }
        ExperienceBoon experienceBoon = (ExperienceBoon)((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getBoon((IPeripheralOwnerBoonKey)PeripheralOwnerBoonKey.Companion.getEXPERIENCE());
        if (experienceBoon != null) {
            experienceBoon.adjustStoredXP((double)recipe.m_43750_());
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final MethodResult smith$lambda$4(SmithingAutomataCorePeripheral this$0, SingleOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
        Container turtleInventory = container;
        int selectedSlot = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        if (selectedSlot + 2 >= turtleInventory.m_6643_()) {
            Object[] objectArray = new Object[]{null, "Cannot use last and pre-last slot as first for smith operation"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        int[] nArray = new int[]{selectedSlot, selectedSlot + 1, selectedSlot + 2};
        LimitedInventory limitedInventory = new LimitedInventory(turtleInventory, nArray);
        Level level = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        Optional optional = level2.m_7465_().m_44015_(RecipeType.f_44113_, (Container)limitedInventory, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRecipeFor(...)");
        Optional optRecipe = optional;
        if (!optRecipe.isPresent()) {
            Object[] objectArray = new Object[]{null, "Cannot find smithing recipe"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Object t = optRecipe.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        SmithingRecipe recipe = (SmithingRecipe)t;
        ItemStack itemStack = recipe.m_5874_((Container)limitedInventory, (RegistryAccess)RegistryAccess.f_243945_);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"assemble(...)");
        ItemStack result = itemStack;
        LimitedInventory.reduceCount$default((LimitedInventory)limitedInventory, (int)0, (int)0, (int)2, null);
        LimitedInventory.reduceCount$default((LimitedInventory)limitedInventory, (int)1, (int)0, (int)2, null);
        LimitedInventory.reduceCount$default((LimitedInventory)limitedInventory, (int)2, (int)0, (int)2, null);
        int n = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        BlockPos blockPos = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getPos().m_121945_(((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getFacing());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
        ContainerUtils.INSTANCE.toInventoryOrToWorld(result, turtleInventory, n, blockPos, level2);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/SmithingAutomataCorePeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "<init>", "()V", "type", "", "getType", "()Ljava/lang/String;", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getType() {
            return type;
        }

        @Override
        @NotNull
        public ResourceLocation getUpgradeID() {
            return PeripheralConfiguration.DefaultImpls.getUpgradeID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransformInteractionMode.values().length];
            try {
                nArray[TransformInteractionMode.BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransformInteractionMode.INVENTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

