/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network.s2c;

import immersive_melodies.Common;
import immersive_melodies.Config;
import immersive_melodies.network.ImmersivePayload;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.MelodyLoader;
import immersive_melodies.resources.ServerMelodyManager;
import immersive_melodies.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record MelodyListMessage(Map<ResourceLocation, MelodyDescriptor> melodies) implements ImmersivePayload
{
    public MelodyListMessage(Player receiver) {
        this(MelodyListMessage.createMelodiesMap(receiver));
    }

    public MelodyListMessage(FriendlyByteBuf b) {
        this(MelodyListMessage.readMelodies(b));
    }

    private static Map<ResourceLocation, MelodyDescriptor> createMelodiesMap(Player receiver) {
        HashMap<ResourceLocation, MelodyDescriptor> melodies = new HashMap<ResourceLocation, MelodyDescriptor>();
        for (Map.Entry<ResourceLocation, MelodyLoader.LazyMelody> lazyMelodyEntry : ServerMelodyManager.getDatapackMelodies().entrySet()) {
            melodies.put(lazyMelodyEntry.getKey(), lazyMelodyEntry.getValue().getDescriptor());
        }
        if (Config.getInstance().showOtherPlayersMelodies) {
            melodies.putAll(ServerMelodyManager.getIndex().getMelodies());
        } else {
            ServerMelodyManager.getIndex().getMelodies().forEach((id, desc) -> {
                if (Utils.ownsMelody(id, receiver)) {
                    melodies.put((ResourceLocation)id, (MelodyDescriptor)desc);
                }
            });
        }
        return melodies;
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        b.writeInt(this.melodies.size());
        for (Map.Entry<ResourceLocation, MelodyDescriptor> entry : this.melodies.entrySet()) {
            b.m_130085_(entry.getKey());
            entry.getValue().encodeLite(b);
        }
    }

    private static Map<ResourceLocation, MelodyDescriptor> readMelodies(FriendlyByteBuf b) {
        int size = b.readInt();
        HashMap<ResourceLocation, MelodyDescriptor> melodies = new HashMap<ResourceLocation, MelodyDescriptor>();
        for (int i = 0; i < size; ++i) {
            melodies.put(b.m_130281_(), new MelodyDescriptor(b));
        }
        return melodies;
    }

    @Override
    public void handle(Player e) {
        Common.networkManager.handleMelodyListMessage(this);
    }
}

