/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.integration;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.integration.FTBTeamsWrapper;
import nx.pingwheel.common.integration.TeamContext;
import nx.pingwheel.common.integration.VoiceChatWrapper;

public class TeamContextHandler {
    private TeamContextHandler() {
    }

    public static boolean hasTeam(Player player) {
        if (player == null) {
            return false;
        }
        return TeamContextHandler.getContext(player) != TeamContext.NONE;
    }

    public static TeamContext getContext(Player player) {
        Optional<UUID> voiceChatId = VoiceChatWrapper.getGroupId(player);
        if (voiceChatId.isPresent()) {
            return TeamContext.VOICE_CHAT;
        }
        Optional<UUID> ftbTeamId = FTBTeamsWrapper.getTeamId(player);
        if (ftbTeamId.isPresent()) {
            return TeamContext.FTB_TEAMS;
        }
        if (player.m_5647_() != null) {
            return TeamContext.VANILLA_TEAM;
        }
        return TeamContext.NONE;
    }

    public static TeamContext getSelfContext() {
        Optional<UUID> voiceChatId = VoiceChatWrapper.getSelfGroupId();
        if (voiceChatId.isPresent()) {
            return TeamContext.VOICE_CHAT;
        }
        Optional<UUID> ftbTeamId = FTBTeamsWrapper.getSelfTeamId();
        if (ftbTeamId.isPresent()) {
            return TeamContext.FTB_TEAMS;
        }
        if (CommonClient.Game.f_91074_ != null && CommonClient.Game.f_91074_.m_5647_() != null) {
            return TeamContext.VANILLA_TEAM;
        }
        return TeamContext.NONE;
    }

    public static boolean inSameContext(Player p1, Player p2) {
        UUID p1TeamId = VoiceChatWrapper.getGroupId(p1).orElse(FTBTeamsWrapper.getTeamId(p1).orElse(null));
        UUID p2TeamId = VoiceChatWrapper.getGroupId(p2).orElse(FTBTeamsWrapper.getTeamId(p2).orElse(null));
        if (p1TeamId != null) {
            return p1TeamId.equals(p2TeamId);
        }
        if (p2TeamId != null) {
            return false;
        }
        return p1.m_5647_() == p2.m_5647_();
    }
}

