/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import de.melanx.simplebackups.BackupData;
import de.melanx.simplebackups.SimpleBackups;
import de.melanx.simplebackups.StorageSize;
import de.melanx.simplebackups.compat.CherishedWorldsCompat;
import de.melanx.simplebackups.compat.Mc2DiscordCompat;
import de.melanx.simplebackups.config.BackupType;
import de.melanx.simplebackups.config.CommonConfig;
import de.melanx.simplebackups.config.ServerConfig;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.FileUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.NetworkHooks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupThread
extends Thread {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    public static final Logger LOGGER = LoggerFactory.getLogger(BackupThread.class);
    public static final long BACKUP_BUFFER_SIZE = 0x8000000L;
    private final MinecraftServer server;
    private final boolean quiet;
    private final long lastSaved;
    private final boolean fullBackup;
    private final LevelStorageSource.LevelStorageAccess storageSource;
    private final Path backupPath;

    private BackupThread(@Nonnull MinecraftServer server, boolean quiet, BackupData backupData) {
        this.server = server;
        this.storageSource = server.f_129744_;
        this.quiet = quiet;
        if (backupData == null) {
            this.lastSaved = 0L;
            this.fullBackup = true;
        } else {
            long l = this.lastSaved = CommonConfig.backupType() == BackupType.MODIFIED_SINCE_LAST ? backupData.getLastSaved() : backupData.getLastFullBackup();
            this.fullBackup = CommonConfig.backupType() == BackupType.FULL_BACKUPS || (CommonConfig.useTickCounter() ? server.m_129783_().m_46467_() : System.currentTimeMillis()) - (long)CommonConfig.getFullBackupTimer() > backupData.getLastFullBackup();
        }
        this.setName("SimpleBackups");
        this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER));
        this.backupPath = CommonConfig.getOutputPath(this.storageSource.f_78272_);
    }

    public static boolean tryCreateBackup(MinecraftServer server) {
        BackupData backupData = BackupData.get(server);
        if (BackupThread.shouldRunBackup(server)) {
            BackupThread thread = new BackupThread(server, false, backupData);
            thread.start();
            long currentTime = CommonConfig.useTickCounter() ? server.m_129783_().m_46467_() : System.currentTimeMillis();
            backupData.updateSaveTime(currentTime);
            if (thread.fullBackup) {
                backupData.updateFullBackupTime(currentTime);
            }
            return true;
        }
        return false;
    }

    public static boolean shouldRunBackup(MinecraftServer server) {
        BackupData backupData = BackupData.get(server);
        if (!CommonConfig.isEnabled() || backupData.isPaused()) {
            return false;
        }
        if (CherishedWorldsCompat.isLoaded() && !CherishedWorldsCompat.isFavorite(server.f_129744_.m_78277_())) {
            return false;
        }
        if (CommonConfig.useTickCounter()) {
            int timer;
            long lastSaved;
            long gameTime = server.m_129783_().m_46467_();
            return gameTime - (lastSaved = backupData.getLastSaved()) >= (long)(timer = CommonConfig.getTimer() * 20 * 60);
        }
        return System.currentTimeMillis() - (long)CommonConfig.getTimer() > backupData.getLastSaved();
    }

    public static void createBackup(MinecraftServer server, boolean quiet) {
        BackupThread thread = new BackupThread(server, quiet, null);
        thread.start();
    }

    public void deleteFiles() {
        ArrayList<File> files;
        File backups = this.backupPath.toFile();
        if (backups.isDirectory() && (files = new ArrayList<File>(Arrays.stream(Objects.requireNonNull(backups.listFiles())).filter(File::isFile).toList())).size() >= CommonConfig.getBackupsToKeep()) {
            files.sort(Comparator.comparingLong(File::lastModified));
            while (files.size() >= CommonConfig.getBackupsToKeep()) {
                boolean deleted = ((File)files.get(0)).delete();
                String name = ((File)files.get(0)).getName();
                if (!deleted) continue;
                files.remove(0);
                LOGGER.info("Successfully deleted \"{}\"", (Object)name);
            }
        }
    }

    public void saveStorageSize() {
        try {
            while (this.getOutputFolderSize() > CommonConfig.getMaxDiskSize()) {
                File[] files = this.backupPath.toFile().listFiles();
                if (Objects.requireNonNull(files).length == 1) {
                    LOGGER.error("Cannot delete old files to save disk space. Only one backup file left!");
                    return;
                }
                Arrays.sort(Objects.requireNonNull(files), Comparator.comparingLong(File::lastModified));
                File file = files[0];
                String name = file.getName();
                if (!file.delete()) continue;
                LOGGER.info("Successfully deleted \"{}\"", (Object)name);
            }
        }
        catch (IOException | NullPointerException e) {
            LOGGER.error("Cannot delete old files to save disk space", (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            this.deleteFiles();
            Files.createDirectories(this.backupPath, new FileAttribute[0]);
            long start = System.currentTimeMillis();
            this.broadcast("simplebackups.backup_started", Style.f_131099_.m_131140_(ChatFormatting.GOLD), new Object[0]);
            long size = this.makeWorldBackup();
            long end = System.currentTimeMillis();
            String time = Timer.getTimer(end - start);
            this.saveStorageSize();
            this.broadcast("simplebackups.backup_finished", Style.f_131099_.m_131140_(ChatFormatting.GOLD), time, StorageSize.getFormattedSize(size), StorageSize.getFormattedSize(this.getOutputFolderSize()));
        }
        catch (IOException e) {
            SimpleBackups.LOGGER.error("Error backing up", (Throwable)e);
        }
    }

    private long getOutputFolderSize() throws IOException {
        File[] files = this.backupPath.toFile().listFiles();
        long size = 0L;
        try {
            for (File file : Objects.requireNonNull(files)) {
                size += Files.size(file.toPath());
            }
        }
        catch (NullPointerException e) {
            return 0L;
        }
        return size;
    }

    private void broadcast(String message, Style style, Object ... parameters) {
        SimpleBackups.LOGGER.info(String.format(ForgeI18n.getPattern((String)message), parameters));
        if (CommonConfig.sendMessages() && !this.quiet) {
            this.server.execute(() -> this.server.m_6846_().m_11314_().forEach(player -> {
                if (ServerConfig.messagesForEveryone() || player.m_20310_(2)) {
                    player.m_213846_((Component)BackupThread.component(player, message, parameters).m_130948_(style));
                }
            }));
            if (Mc2DiscordCompat.isLoaded() && CommonConfig.mc2discord()) {
                Mc2DiscordCompat.announce((Component)BackupThread.component(null, message, parameters));
            }
        }
    }

    public static MutableComponent component(@Nullable ServerPlayer player, String key, Object ... parameters) {
        ConnectionData data;
        if (player != null && (data = NetworkHooks.getConnectionData((Connection)player.f_8906_.f_9742_)) != null && data.getModList().contains((Object)"simplebackups")) {
            return Component.m_237110_((String)key, (Object[])parameters);
        }
        return Component.m_237113_((String)String.format(ForgeI18n.getPattern((String)key), parameters));
    }

    private long makeWorldBackup() throws IOException {
        this.storageSource.m_78313_();
        if (CommonConfig.saveAll()) {
            this.server.m_18709_(() -> this.server.m_195514_(true, false, true));
        }
        String fileName = this.storageSource.f_78272_ + "_" + LocalDateTime.now().format(FORMATTER);
        Path path = CommonConfig.getOutputPath(this.storageSource.f_78272_);
        try {
            Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        Path outputFile = path.resolve(FileUtil.m_133730_((Path)path, (String)fileName, (String)".zip"));
        final ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(outputFile, new OpenOption[0])));
        zipStream.setLevel(CommonConfig.getCompressionLevel());
        final AtomicBoolean aborted = new AtomicBoolean(false);
        try {
            final Path levelName = Paths.get(this.storageSource.f_78272_, new String[0]);
            final Path levelPath = this.storageSource.getWorldDir().resolve(this.storageSource.f_78272_).toRealPath(new LinkOption[0]);
            final List<Path> ignoredPaths = CommonConfig.getIgnoredPaths();
            final List<Path> ignoredFiles = CommonConfig.getIgnoredFiles();
            final String ignoredFilesRegex = CommonConfig.getIgnoredFilesRegex();
            final boolean ignoreSomething = !ignoredPaths.isEmpty() || !ignoredFiles.isEmpty() || !ignoredFilesRegex.isEmpty();
            final FileStore fileStore = Files.getFileStore(outputFile);
            Files.walkFileTree(levelPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @Nonnull
                public FileVisitResult visitFile(@Nonnull Path file, @Nonnull BasicFileAttributes attrs) throws IOException {
                    if (file.endsWith("session.lock")) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (file.endsWith("biomancy.spatial.db")) {
                        SimpleBackups.LOGGER.info("Skipping \"{}\" - see https://github.com/Elenterius/Biomancy/issues/175", (Object)levelPath.relativize(file));
                        return FileVisitResult.CONTINUE;
                    }
                    if (ignoreSomething && this.shouldSkipFile(levelPath.relativize(file))) {
                        SimpleBackups.LOGGER.debug("Skipping file: {}", (Object)file);
                        return FileVisitResult.CONTINUE;
                    }
                    long lastModified = file.toFile().lastModified();
                    if (BackupThread.this.fullBackup || lastModified - BackupThread.this.lastSaved > 0L) {
                        if (fileStore.getUsableSpace() - attrs.size() - 0x8000000L < 0L) {
                            BackupThread.this.broadcast("simplebackups.not_enough_space", Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
                            aborted.set(true);
                            throw new IOException("Not enough space on disk to create backup");
                        }
                        String completePath = levelName.resolve(levelPath.relativize(file)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(completePath);
                        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                            zipStream.putNextEntry(zipentry);
                            inputStream.transferTo(zipStream);
                            zipStream.closeEntry();
                        }
                        catch (IOException e) {
                            this.visitFileFailed(file, e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @Nonnull
                public FileVisitResult visitFileFailed(@Nonnull Path file, @Nonnull IOException exc) throws IOException {
                    if (exc instanceof NoSuchFileException || exc instanceof FileNotFoundException) {
                        SimpleBackups.LOGGER.debug("Skipped vanished file: {}", (Object)file);
                        return FileVisitResult.CONTINUE;
                    }
                    IOException detailedException = new IOException("Failed to backup file: " + file, exc);
                    return super.visitFileFailed(file, detailedException);
                }

                private boolean shouldSkipFile(Path relativePath) {
                    return ignoredPaths.contains(relativePath.getParent()) || ignoredFiles.contains(relativePath) || !ignoredFilesRegex.isEmpty() && this.getNormalizedPath(relativePath).matches(ignoredFilesRegex);
                }

                private String getNormalizedPath(Path path) {
                    return path.toString().replace('\\', '/');
                }
            });
        }
        catch (IOException e) {
            try {
                zipStream.close();
            }
            catch (IOException e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
        finally {
            if (aborted.get()) {
                Files.deleteIfExists(outputFile);
            }
        }
        zipStream.close();
        return Files.size(outputFile);
    }

    private static class Timer {
        private static final SimpleDateFormat SECONDS = new SimpleDateFormat("s.SSS");
        private static final SimpleDateFormat MINUTES = new SimpleDateFormat("mm:ss");
        private static final SimpleDateFormat HOURS = new SimpleDateFormat("HH:mm");

        private Timer() {
        }

        public static String getTimer(long milliseconds) {
            Date date = new Date(milliseconds);
            double seconds = (double)milliseconds / 1000.0;
            if (seconds < 60.0) {
                return SECONDS.format(date) + "s";
            }
            if (seconds < 3600.0) {
                return MINUTES.format(date) + "min";
            }
            return HOURS.format(date) + "h";
        }
    }
}

