/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.impacts;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.effects.particles.impacts.SparkParticleData;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class SparkParticle
extends Particle {
    private static final ResourceLocation COLOR_LOCATION = CreateBigCannons.resource("textures/entity/color.png");
    private static final RenderType COLOR = RenderType.m_110470_((ResourceLocation)COLOR_LOCATION);
    private static final ParticleRenderType RENDER_TYPE = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.setShader(GameRenderer::m_172676_);
            COLOR.m_110185_();
            builder.m_166779_(COLOR.m_173186_(), COLOR.m_110508_());
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }

        public String toString() {
            return "SPARK";
        }
    };

    SparkParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        super(level, x, y, z);
        this.f_107215_ = dx;
        this.f_107216_ = dy;
        this.f_107217_ = dz;
        this.f_107227_ = r;
        this.f_107228_ = g;
        this.f_107229_ = b;
        this.f_107226_ = 0.5f;
        this.f_172258_ = 0.8f;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 vec3 = renderInfo.m_90583_();
        double dx = this.f_107212_ - this.f_107209_;
        double dy = this.f_107213_ - this.f_107210_;
        double dz = this.f_107214_ - this.f_107211_;
        float x1 = (float)(this.f_107209_ + (double)partialTicks * dx - vec3.m_7096_());
        float y1 = (float)(this.f_107210_ + (double)partialTicks * dy - vec3.m_7098_());
        float z1 = (float)(this.f_107211_ + (double)partialTicks * dz - vec3.m_7094_());
        Vec3 vel = new Vec3(dx, dy, dz);
        Matrix3f orient = CBCUtils.mat3x3fFacing(vel.m_82541_());
        float width = 0.0625f;
        float length = -Math.min((float)vel.m_82553_(), 1.0f);
        int p = this.m_6355_(partialTicks);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-width, 0.0f, 0.0f), new Vector3f(-width, 0.0f, length), new Vector3f(width, 0.0f, length), new Vector3f(width, 0.0f, 0.0f), new Vector3f(-width, 0.0f, 0.0f), new Vector3f(width, 0.0f, 0.0f), new Vector3f(width, 0.0f, length), new Vector3f(-width, 0.0f, length), new Vector3f(0.0f, -width, 0.0f), new Vector3f(0.0f, -width, length), new Vector3f(0.0f, width, length), new Vector3f(0.0f, width, 0.0f), new Vector3f(0.0f, -width, 0.0f), new Vector3f(0.0f, width, 0.0f), new Vector3f(0.0f, width, length), new Vector3f(0.0f, -width, length)};
        for (int vert = 0; vert < 16; ++vert) {
            Vector3f vector3f2 = vector3fs[vert];
            orient.transform(vector3f2);
            buffer.m_5483_((double)(vector3f2.x() + x1), (double)(vector3f2.y() + y1), (double)(vector3f2.z() + z1)).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(p).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
    }

    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }

    public void m_5989_() {
        if (this.f_107218_) {
            this.m_107274_();
            return;
        }
        this.f_107227_ *= 0.99f;
        this.f_107228_ *= 0.98f;
        this.f_107229_ *= 0.97f;
        super.m_5989_();
    }

    public int m_6355_(float partialTick) {
        float progress = 1.0f - Mth.m_14036_((float)(((float)this.f_107224_ + partialTick) / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        float brightness = Math.max(0.75f, progress * progress * progress * progress);
        int i = super.m_6355_(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(brightness * 240.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class Provider
    implements ParticleProvider<SparkParticleData> {
        public Particle createParticle(SparkParticleData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Vector3f color = type.color();
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, color.x(), color.y(), color.z());
            int lifetime = 12 + level.f_46441_.m_188503_(12);
            particle.m_107257_(lifetime);
            return particle;
        }
    }
}

