/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.recipes;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.datagen.recipes.BuiltUpHeatingRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.CannonCastRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.DrillBoringRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.FinishedBlockRecipe;

public abstract class BlockRecipeProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PackOutput output;
    protected final String modid;
    protected ResourceLocation info;
    protected static final List<DataProvider.Factory<BlockRecipeProvider>> GENERATORS = new ArrayList<DataProvider.Factory<BlockRecipeProvider>>();

    public BlockRecipeProvider(String modid, PackOutput output) {
        this.modid = modid;
        this.output = output;
    }

    public static void registerAll(Consumer<DataProvider.Factory<?>> cons) {
        GENERATORS.add((DataProvider.Factory<BlockRecipeProvider>)((DataProvider.Factory)CannonCastRecipeProvider::new));
        GENERATORS.add((DataProvider.Factory<BlockRecipeProvider>)((DataProvider.Factory)BuiltUpHeatingRecipeProvider::new));
        GENERATORS.add((DataProvider.Factory<BlockRecipeProvider>)((DataProvider.Factory)DrillBoringRecipeProvider::new));
        cons.accept(output -> new DataProvider(){

            public CompletableFuture<?> m_213708_(CachedOutput cache) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> ((BlockRecipeProvider)gen.m_253034_(output)).m_213708_(cache)).toArray(CompletableFuture[]::new));
            }

            public String m_6055_() {
                return "Create Big Cannons Block Recipes";
            }
        });
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Path path = this.output.m_245114_();
        HashMap map = new HashMap();
        this.registerRecipes(recipe -> {
            if (map.put(recipe.id(), recipe) != null) {
                throw new IllegalStateException("Duplicate block recipe " + String.valueOf(recipe.id()));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(e -> {
            ResourceLocation id = (ResourceLocation)e.getKey();
            FinishedBlockRecipe recipe = (FinishedBlockRecipe)e.getValue();
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)recipe.serializeRecipe(), (Path)path.resolve("data/" + id.m_135827_() + "/block_recipes/" + id.m_135815_() + ".json"));
        }).toArray(CompletableFuture[]::new));
    }

    private static void saveRecipe(CachedOutput cache, JsonObject obj, Path path) {
        try {
            String s = GSON.toJson((JsonElement)obj);
            HashCode s1 = Hashing.sha1().hashUnencodedChars((CharSequence)s);
            cache.m_213871_(path, s.getBytes(), s1);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save block recipe {}", (Object)path, (Object)e);
        }
    }

    protected abstract void registerRecipes(Consumer<FinishedBlockRecipe> var1);

    public String m_6055_() {
        return "Create Big Cannons Block Recipes: " + String.valueOf(this.info == null ? "unknown id" : this.info);
    }
}

