/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Blocks;
import org.violetmoon.quark.content.tweaks.client.layer.ArmorStandFakePlayerLayer;
import org.violetmoon.zeta.client.event.load.ZAddModelLayers;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="client")
public class UsesForCursesModule
extends ZetaModule {
    private static final ResourceLocation PUMPKIN_OVERLAY = new ResourceLocation("textures/misc/pumpkinblur.png");
    public static boolean staticEnabled;
    @Config(flag="use_for_vanishing")
    public static boolean vanishPumpkinOverlay;
    @Config(flag="use_for_binding")
    public static boolean bindArmorStandsWithPlayerHeads;
    @Hint(key="use_for_vanishing", value="use_for_vanishing")
    Item pumpkin = Items.f_42047_;
    @Hint(key="use_for_binding", value="use_for_binding")
    List<Item> bindingItems = Arrays.asList(Items.f_42650_, Items.f_42680_);

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    public static boolean shouldHideArmorStandModel(ItemStack stack) {
        if (!(staticEnabled && bindArmorStandsWithPlayerHeads && stack.m_150930_(Items.f_42680_))) {
            return false;
        }
        return EnchantmentHelper.m_44920_((ItemStack)stack);
    }

    public static boolean shouldHidePumpkinOverlay(ResourceLocation location, Player player) {
        if (!(staticEnabled && vanishPumpkinOverlay && location.equals((Object)PUMPKIN_OVERLAY))) {
            return false;
        }
        ItemStack stack = player.m_150109_().m_36052_(3);
        return stack.m_150930_(Blocks.f_50143_.m_5456_()) && EnchantmentHelper.m_44924_((ItemStack)stack);
    }

    static {
        vanishPumpkinOverlay = true;
        bindArmorStandsWithPlayerHeads = true;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends UsesForCursesModule {
        @LoadEvent
        public void modelLayers(ZAddModelLayers event) {
            ArmorStandRenderer render = (ArmorStandRenderer)event.getRenderer(EntityType.f_20529_);
            render.m_115326_(new ArmorStandFakePlayerLayer(render, event.getEntityModels()));
        }
    }
}

