/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.village;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.BWGStructureProcessorLists;
import org.jetbrains.annotations.NotNull;

public class PlaceInVillage {
    private static void addBuildingToPool(@NotNull MinecraftServer server, ResourceLocation poolRL, ResourceKey<StructureProcessorList> processorList, ResourceLocation nbtPieceRL, StructureTemplatePool.Projection projection, int weight) {
        RegistryAccess.Frozen serverRegistry = server.m_206579_();
        Registry templatePoolRegistry = (Registry)serverRegistry.m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorListRegistry = (Registry)serverRegistry.m_6632_(Registries.f_257011_).orElseThrow();
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        Holder.Reference processorList1 = processorListRegistry.m_246971_(processorList);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210531_((String)nbtPieceRL.toString(), (Holder)processorList1).apply(projection);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }

    public static void addStructuresToVillages(@NotNull MinecraftServer server) {
        PlaceInVillage.addBuildingToPool(server, PlaceInVillage.getMcRL("plains/houses"), BWGStructureProcessorLists.MOSSIFY_10_PERCENT_WHITE_PUFFBALL, BiomesWeveGone.id("minecraft/village/plains/houses/plains_forager_1"), StructureTemplatePool.Projection.RIGID, 2);
        PlaceInVillage.addBuildingToPool(server, PlaceInVillage.getMcRL("taiga/houses"), BWGStructureProcessorLists.MOSSIFY_10_PERCENT_WHITE_PUFFBALL, BiomesWeveGone.id("minecraft/village/taiga/houses/taiga_forager_1"), StructureTemplatePool.Projection.RIGID, 2);
    }

    private static ResourceLocation getMcRL(String poolName) {
        return new ResourceLocation("village/" + poolName);
    }
}

