/*
 * Decompiled with CFR 0.152.
 */
package com.shmove.cat_jam.discs;

import com.shmove.cat_jam.discs.Disc;

public class DiscPlayback {
    private final Disc disc;
    private int beat = 0;
    private int segment = 0;
    private int offsetTicks;
    private int ticksTilBeat = 0;
    private double tickError = 0.0;

    public DiscPlayback(Disc disc) {
        this.disc = disc;
        this.offsetTicks = (int)Math.floor(20.0 * disc.offsetInSeconds());
    }

    private void setTicksToNextBeat() {
        if (this.ticksTilBeat <= 0) {
            double v = this.disc.getSegment(this.segment).beatTickInterval();
            this.ticksTilBeat = (int)Math.floor(v);
            this.tickError += v - (double)this.ticksTilBeat;
            while (this.tickError >= 0.5) {
                ++this.ticksTilBeat;
                this.tickError -= 1.0;
            }
        }
    }

    public void tick() {
        if (this.offsetTicks > 0) {
            --this.offsetTicks;
            return;
        }
        if (this.ticksTilBeat <= 0) {
            ++this.beat;
            if (this.beat >= this.disc.getSegment(this.segment).lengthInBeats() && this.disc.getSegment(this.segment).lengthInBeats() != -1) {
                this.beat = 0;
                ++this.segment;
            }
            this.setTicksToNextBeat();
        }
        --this.ticksTilBeat;
    }

    public boolean anticipateBeat(int ticks) {
        if (this.offsetTicks > 0) {
            return this.offsetTicks <= ticks;
        }
        return this.ticksTilBeat <= ticks;
    }

    public boolean isNodBeat() {
        return this.disc.getSegment(this.segment).nodPattern().getNodType(this.beat) == 'X';
    }

    public boolean isSlightNodBeat() {
        return this.disc.getSegment(this.segment).nodPattern().getNodType(this.beat) == 'x';
    }

    public boolean isPauseBeat() {
        return this.disc.getSegment(this.segment).nodPattern().getNodType(this.beat) == '_';
    }

    public Disc getDisc() {
        return this.disc;
    }
}

