/*
 * Decompiled with CFR 0.152.
 */
package com.shmove.cat_jam.discs;

import com.shmove.cat_jam.discs.DiscSegment;
import java.util.List;

public record Disc(String id, List<DiscSegment> segments, double offsetInSeconds) {
    public Disc {
        if (segments == null || segments.isEmpty()) {
            throw new IllegalArgumentException("Disc " + id + " has no segments");
        }
        if (offsetInSeconds < 0.0) {
            throw new IllegalArgumentException("Disc " + id + " has negative offset");
        }
    }

    public Disc(String id, double bpm, double offsetInSeconds) {
        this(id, List.of(new DiscSegment(bpm)), offsetInSeconds);
    }

    public DiscSegment getSegment(int index) {
        if (index < 0 || index >= this.segments.size()) {
            throw new IndexOutOfBoundsException("Segment index " + index + " out of bounds for disc " + this.id);
        }
        return this.segments.get(index);
    }
}

