/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.particles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.FlashParticleS2C;
import net.soulsweaponry.networking.packets.S2C.ParticleOutburstS2C;
import net.soulsweaponry.networking.packets.S2C.ParticleSphereS2C;

public class ParticleHandler {
    public static void particleOutburstMap(Level world, int amount, double x, double y, double z, HashMap<ParticleOptions, Vec3> particleMap, float sizeMod) {
        for (ParticleOptions particle : particleMap.keySet()) {
            ParticleHandler.particleOutburst(world, amount, x, y, z, particle, particleMap.get(particle), sizeMod);
        }
    }

    public static void particleSphereList(Level world, int amount, double x, double y, double z, float sizeMod, ParticleOptions ... particles) {
        for (ParticleOptions particle : particles) {
            ParticleHandler.particleSphere(world, amount, x, y, z, particle, sizeMod);
        }
    }

    public static void particleSphereList(Level world, int amount, double x, double y, double z, List<ParticleOptions> particles, float sizeMod) {
        for (ParticleOptions particle : particles) {
            ParticleHandler.particleSphere(world, amount, x, y, z, particle, sizeMod);
        }
    }

    public static void particleOutburst(Level world, int amount, double x, double y, double z, ParticleOptions particle, Vec3 velDivider, float sizeMod) {
        if (world.f_46443_) {
            List<Vec3> list = ParticleHandler.getParticleOutburstCords(amount, velDivider, sizeMod);
            for (Vec3 vec : list) {
                world.m_7106_(particle, x, y, z, vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
            }
        } else {
            ItemStack stack = new ItemStack((ItemLike)Items.f_41852_);
            if (particle instanceof ItemParticleOption) {
                ItemParticleOption par = (ItemParticleOption)particle;
                stack = par.m_123718_();
                particle = ParticleTypes.f_123744_;
            }
            ModMessages.sendToAllPlayers(new ParticleOutburstS2C(amount, x, y, z, particle, velDivider, sizeMod, stack));
        }
    }

    public static void particleSphere(Level world, int amount, double x, double y, double z, ParticleOptions particle, float sizeMod) {
        if (world.f_46443_) {
            List<Vec3> list = ParticleHandler.getSphereParticleCords(amount, sizeMod);
            for (Vec3 vec : list) {
                world.m_7106_(particle, x, y, z, vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
            }
        } else {
            ItemStack stack = new ItemStack((ItemLike)Items.f_41852_);
            if (particle instanceof ItemParticleOption) {
                ItemParticleOption par = (ItemParticleOption)particle;
                stack = par.m_123718_();
                particle = ParticleTypes.f_123744_;
            }
            ModMessages.sendToAllPlayers(new ParticleSphereS2C(amount, x, y, z, particle, sizeMod, stack));
        }
    }

    public static void flashParticle(Level world, double x, double y, double z, RGB rgb, float expansion) {
        if (world.f_46443_) {
            Particle flash = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123747_, x, y, z, 0.0, 0.0, 0.0);
            flash.m_107259_(new AABB(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_82400_((double)expansion));
            flash.m_107253_(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
        } else {
            ModMessages.sendToAllPlayers(new FlashParticleS2C(x, y, z, rgb, expansion));
        }
    }

    public static List<Vec3> getParticleOutburstCords(int particleAmount, Vec3 velDividers, double sizeMod) {
        Random random = new Random();
        ArrayList<Vec3> list = new ArrayList<Vec3>();
        double d = random.nextGaussian() * 0.05;
        double e = random.nextGaussian() * 0.05;
        double f = random.nextGaussian() * 0.05;
        for (int j = 0; j < particleAmount; ++j) {
            double newX = (random.nextDouble() - 0.5 + random.nextGaussian() * 0.15 + d) * sizeMod;
            double newZ = (random.nextDouble() - 0.5 + random.nextGaussian() * 0.15 + e) * sizeMod;
            double newY = (random.nextDouble() - 0.5 + random.nextGaussian() * 0.15 + f) * sizeMod;
            Vec3 vec = new Vec3(newX / velDividers.m_7096_(), newY / velDividers.m_7098_(), newZ / velDividers.m_7094_());
            list.add(vec);
        }
        return list;
    }

    public static List<Vec3> getSphereParticleCords(double points, float sizeModifier) {
        ArrayList<Vec3> list = new ArrayList<Vec3>();
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            Vec3 vec = new Vec3(velocityX * (double)sizeModifier, velocityY * (double)sizeModifier, velocityZ * (double)sizeModifier);
            list.add(vec);
            ++i;
        }
        return list;
    }

    public static class RGB {
        float r;
        float g;
        float b;

        public RGB(float red, float green, float blue) {
            this.r = red / 255.0f;
            this.g = green / 255.0f;
            this.b = blue / 255.0f;
        }

        public float getRed() {
            return this.r;
        }

        public float getGreen() {
            return this.g;
        }

        public float getBlue() {
            return this.b;
        }
    }
}

