/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.particles;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.ParticleRegistry;

public class ParticleEvents {
    public static final Vec3 FLAT_SPREADING_FLAME = new Vec3(2.0, 8.0, 2.0);
    public static final Vec3 FLAT_SPREADING_SMOKE = new Vec3(1.0, 8.0, 1.0);
    public static final Vec3 RISING_FLAME = new Vec3(8.0, 2.0, 8.0);
    public static final Vec3 RISING_ITEM_PARTICLE = new Vec3(2.0, 0.5, 2.0);
    public static final Vec3 FLAT_ITEM_PARTICLE = new Vec3(1.0, 2.0, 1.0);
    public static final ParticleOptions DIRT_PARTICLE = new ItemParticleOption(ParticleTypes.f_123752_, Items.f_42329_.m_7968_());
    public static final ParticleOptions STONE_PARTICLE = new ItemParticleOption(ParticleTypes.f_123752_, Items.f_41905_.m_7968_());
    public static final ParticleOptions ICE_PARTICLE = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_41980_));
    public static final HashMap<ParticleOptions, Vec3> OBLITERATE_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> MOONFALL_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> SOUL_RUPTURE_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> DAWNBREAKER_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> DARKIN_BLADE_SLAM_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> CONJURE_ENTITY_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> GROUND_RUPTURE_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> BLINDING_LIGHT_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> DEFAULT_GRAND_SKYFALL_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> BASE_GRAND_SKYFALL_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> BLINDING_LIGHT_SMASH_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> SOUL_FLAME_RUPTURE_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> SOUL_FLAME_SMALL_OUTBURST_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> ICE_SMASH_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> BLACKFLAME_SNAKE_PARTICLE_MAP = Maps.newHashMap();
    public static final HashMap<ParticleOptions, Vec3> FLAME_RUPTURE_MAP = Maps.newHashMap();
    public static final List<ParticleOptions> DARK_EXPLOSION_LIST = List.of(ParticleTypes.f_123755_, ParticleTypes.f_123762_, ParticleTypes.f_123759_);

    public static void dawnbreakerEvent(Level world, double x, double y, double z, float sizeMod) {
        ParticleHandler.particleOutburstMap(world, 200, x, y + (double)0.1f, z, DAWNBREAKER_MAP, sizeMod);
        ParticleHandler.particleSphere(world, 1000, x, y + (double)0.1f, z, (ParticleOptions)ParticleTypes.f_123744_, sizeMod);
    }

    public static void mjolnirLeviathanAxeCollision(Level world, double x, double y, double z) {
        HashMap map = Maps.newHashMap();
        Vec3 vec = new Vec3(1.0, 1.0, 1.0);
        map.put(ParticleTypes.f_175830_, vec);
        map.put(ParticleTypes.f_123796_, vec);
        map.put(ParticleTypes.f_175831_, vec);
        map.put(ParticleTypes.f_175827_, vec);
        ParticleHandler.particleSphereList(world, 1000, x, y, z, 1.0f, new ParticleOptions[]{ParticleTypes.f_123755_, (ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get()});
        ParticleHandler.particleOutburstMap(world, 500, x, y, z, map, 1.0f);
        ParticleHandler.flashParticle(world, x, y, z, new ParticleHandler.RGB(79.0f, 255.0f, 243.0f), 10.0f);
    }

    public static void airCombustionEvent(Level world, double x, double y, double z) {
        HashMap map = Maps.newHashMap();
        Vec3 vec = new Vec3(3.0, 3.0, 3.0);
        map.put(ParticleTypes.f_123755_, vec);
        map.put(ParticleTypes.f_123744_, vec);
        ParticleHandler.particleOutburstMap(world, 100, x, y, z, map, 1.0f);
        ParticleHandler.flashParticle(world, x, y, z, new ParticleHandler.RGB(201.0f, 64.0f, 0.0f), 1.0f);
    }

    static {
        OBLITERATE_MAP.put((ParticleOptions)ParticleTypes.f_123755_, FLAT_SPREADING_SMOKE);
        OBLITERATE_MAP.put((ParticleOptions)ParticleTypes.f_123745_, FLAT_SPREADING_FLAME);
        OBLITERATE_MAP.put((ParticleOptions)ParticleTypes.f_123746_, FLAT_SPREADING_FLAME);
        OBLITERATE_MAP.put(DIRT_PARTICLE, FLAT_ITEM_PARTICLE);
        OBLITERATE_MAP.put(STONE_PARTICLE, FLAT_ITEM_PARTICLE);
        MOONFALL_MAP.put((ParticleOptions)ParticleTypes.f_123755_, FLAT_SPREADING_SMOKE);
        MOONFALL_MAP.put((ParticleOptions)ParticleTypes.f_123745_, FLAT_SPREADING_FLAME);
        MOONFALL_MAP.put((ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get(), FLAT_SPREADING_FLAME);
        MOONFALL_MAP.put(DIRT_PARTICLE, FLAT_ITEM_PARTICLE);
        MOONFALL_MAP.put(STONE_PARTICLE, FLAT_ITEM_PARTICLE);
        SOUL_RUPTURE_MAP.put((ParticleOptions)ParticleTypes.f_123746_, RISING_FLAME);
        SOUL_RUPTURE_MAP.put((ParticleOptions)ParticleTypes.f_123745_, RISING_FLAME);
        SOUL_RUPTURE_MAP.put((ParticleOptions)ParticleTypes.f_123755_, RISING_FLAME);
        DAWNBREAKER_MAP.put((ParticleOptions)ParticleTypes.f_123755_, FLAT_SPREADING_SMOKE);
        DAWNBREAKER_MAP.put((ParticleOptions)ParticleTypes.f_123745_, FLAT_SPREADING_FLAME);
        DAWNBREAKER_MAP.put((ParticleOptions)ParticleTypes.f_123746_, FLAT_SPREADING_FLAME);
        DARKIN_BLADE_SLAM_MAP.put((ParticleOptions)ParticleTypes.f_123755_, FLAT_SPREADING_SMOKE);
        DARKIN_BLADE_SLAM_MAP.put((ParticleOptions)ParticleTypes.f_123744_, FLAT_SPREADING_FLAME);
        DARKIN_BLADE_SLAM_MAP.put((ParticleOptions)ParticleTypes.f_123746_, FLAT_SPREADING_FLAME);
        CONJURE_ENTITY_MAP.put((ParticleOptions)ParticleTypes.f_123746_, RISING_FLAME);
        CONJURE_ENTITY_MAP.put((ParticleOptions)ParticleTypes.f_123799_, RISING_FLAME);
        GROUND_RUPTURE_MAP.put((ParticleOptions)ParticleTypes.f_123755_, RISING_ITEM_PARTICLE);
        GROUND_RUPTURE_MAP.put(DIRT_PARTICLE, RISING_ITEM_PARTICLE);
        GROUND_RUPTURE_MAP.put(STONE_PARTICLE, RISING_ITEM_PARTICLE);
        BLINDING_LIGHT_MAP.put((ParticleOptions)ParticleTypes.f_175829_, new Vec3((double)0.05f, (double)0.05f, (double)0.05f));
        BLINDING_LIGHT_MAP.put((ParticleOptions)ParticleTypes.f_123746_, new Vec3(4.0, 4.0, 4.0));
        DEFAULT_GRAND_SKYFALL_MAP.put((ParticleOptions)ParticleTypes.f_123755_, FLAT_SPREADING_SMOKE);
        BASE_GRAND_SKYFALL_MAP.put((ParticleOptions)ParticleTypes.f_123755_, FLAT_SPREADING_SMOKE);
        DEFAULT_GRAND_SKYFALL_MAP.put((ParticleOptions)ParticleTypes.f_123744_, new Vec3(1.0, 6.0, 1.0));
        DEFAULT_GRAND_SKYFALL_MAP.put(DIRT_PARTICLE, FLAT_ITEM_PARTICLE);
        BASE_GRAND_SKYFALL_MAP.put(DIRT_PARTICLE, FLAT_ITEM_PARTICLE);
        DEFAULT_GRAND_SKYFALL_MAP.put(STONE_PARTICLE, FLAT_ITEM_PARTICLE);
        BASE_GRAND_SKYFALL_MAP.put(STONE_PARTICLE, FLAT_ITEM_PARTICLE);
        BLINDING_LIGHT_SMASH_MAP.put((ParticleOptions)ParticleTypes.f_123755_, FLAT_SPREADING_SMOKE);
        BLINDING_LIGHT_SMASH_MAP.put((ParticleOptions)ParticleTypes.f_123815_, FLAT_SPREADING_FLAME);
        BLINDING_LIGHT_SMASH_MAP.put((ParticleOptions)ParticleTypes.f_175829_, FLAT_SPREADING_FLAME);
        BLINDING_LIGHT_SMASH_MAP.put(DIRT_PARTICLE, FLAT_ITEM_PARTICLE);
        BLINDING_LIGHT_SMASH_MAP.put(STONE_PARTICLE, FLAT_ITEM_PARTICLE);
        SOUL_FLAME_RUPTURE_MAP.put((ParticleOptions)ParticleTypes.f_123745_, new Vec3(2.0, 0.5, 2.0));
        SOUL_FLAME_RUPTURE_MAP.put((ParticleOptions)ParticleTypes.f_123755_, new Vec3(2.0, 0.5, 2.0));
        SOUL_FLAME_SMALL_OUTBURST_MAP.put((ParticleOptions)ParticleTypes.f_123755_, new Vec3(3.0, 3.0, 3.0));
        SOUL_FLAME_SMALL_OUTBURST_MAP.put((ParticleOptions)ParticleTypes.f_123745_, new Vec3(3.0, 3.0, 3.0));
        ICE_SMASH_MAP.put((ParticleOptions)ParticleTypes.f_123796_, FLAT_SPREADING_SMOKE);
        ICE_SMASH_MAP.put((ParticleOptions)ParticleTypes.f_123746_, FLAT_SPREADING_FLAME);
        ICE_SMASH_MAP.put(ICE_PARTICLE, new Vec3(1.0, 1.0, 1.0));
        BLACKFLAME_SNAKE_PARTICLE_MAP.put((ParticleOptions)ParticleTypes.f_123755_, RISING_ITEM_PARTICLE);
        BLACKFLAME_SNAKE_PARTICLE_MAP.put((ParticleOptions)ParticleRegistry.DAZZLING_PARTICLE.get(), RISING_ITEM_PARTICLE);
        BLACKFLAME_SNAKE_PARTICLE_MAP.put((ParticleOptions)ParticleRegistry.DARK_STAR.get(), RISING_ITEM_PARTICLE);
        FLAME_RUPTURE_MAP.put((ParticleOptions)ParticleTypes.f_123744_, new Vec3(4.0, 0.5, 4.0));
        FLAME_RUPTURE_MAP.put((ParticleOptions)ParticleTypes.f_175828_, new Vec3((double)0.1f, (double)0.01f, (double)0.1f));
        FLAME_RUPTURE_MAP.put((ParticleOptions)ParticleTypes.f_175834_, new Vec3(4.0, 0.5, 4.0));
    }
}

