/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.S2C;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.client.entitydata.ClientReturningProjectileData;

public class ReturningProjectileDataSyncS2C {
    private final UUID uuid;

    public ReturningProjectileDataSyncS2C(UUID uuid) {
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
    }

    public ReturningProjectileDataSyncS2C(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            this.handlePacket(world, this);
        }));
        context.setPacketHandled(true);
    }

    private void handlePacket(ClientLevel world, ReturningProjectileDataSyncS2C packet) {
        ClientReturningProjectileData.setUUID(packet.getUuid());
    }
}

