/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.S2C;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.client.entitydata.ClientPostureData;

public class PostureSyncS2C {
    private final int posture;

    public PostureSyncS2C(int posture) {
        this.posture = posture;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.posture);
    }

    public PostureSyncS2C(FriendlyByteBuf buf) {
        this.posture = buf.readInt();
    }

    public int getPosture() {
        return this.posture;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            this.handlePacket(world, this);
        }));
        context.setPacketHandled(true);
    }

    private void handlePacket(ClientLevel world, PostureSyncS2C packet) {
        ClientPostureData.setPosture(packet.getPosture());
    }
}

