/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.S2C;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.particles.ParticleHandler;

public class ParticleOutburstS2C {
    private final double x;
    private final double y;
    private final double z;
    private final int amount;
    private final ParticleOptions particle;
    private final Vec3 velDividers;
    private final float sizeMod;
    private final ItemStack item;

    public ParticleOutburstS2C(int amount, double x, double y, double z, ParticleOptions particle, Vec3 velDividers, float sizeMod, ItemStack item) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.amount = amount;
        this.item = item;
        this.particle = particle;
        this.velDividers = velDividers;
        this.sizeMod = sizeMod;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(BuiltInRegistries.f_257034_.m_7447_((Object)this.particle.m_6012_()));
        buf.writeInt(this.amount);
        buf.m_130055_(this.item);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.velDividers.f_82479_);
        buf.writeDouble(this.velDividers.f_82480_);
        buf.writeDouble(this.velDividers.f_82481_);
        buf.writeFloat(this.sizeMod);
        this.particle.m_7711_(buf);
    }

    public ParticleOutburstS2C(FriendlyByteBuf buf) {
        ParticleType particletype = (ParticleType)BuiltInRegistries.f_257034_.m_7942_(buf.readInt());
        this.particle = this.readParticle(buf, particletype);
        this.amount = buf.readInt();
        this.item = buf.m_130267_();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.velDividers = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.sizeMod = buf.readFloat();
    }

    public int getAmount() {
        return this.amount;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    private <T extends ParticleOptions> T readParticle(FriendlyByteBuf pBuffer, ParticleType<T> pParticleType) {
        return (T)pParticleType.m_123743_().m_6507_(pParticleType, pBuffer);
    }

    public ParticleOptions getParticle() {
        return this.particle;
    }

    public Vec3 getVelDividers() {
        return this.velDividers;
    }

    public float getSizeMod() {
        return this.sizeMod;
    }

    private ItemParticleOption getItemParticleOption() {
        return new ItemParticleOption(ParticleTypes.f_123752_, this.item);
    }

    private ItemStack getItemStack() {
        return this.item;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            this.handlePacket(world, this);
        }));
        context.setPacketHandled(true);
    }

    private void handlePacket(ClientLevel world, ParticleOutburstS2C packet) {
        Object particleEffect = !packet.getItemStack().m_150930_(Items.f_41852_) ? packet.getItemParticleOption() : packet.getParticle();
        List<Vec3> list = ParticleHandler.getParticleOutburstCords(packet.getAmount(), packet.getVelDividers(), packet.getSizeMod());
        for (Vec3 vec : list) {
            world.m_7106_((ParticleOptions)particleEffect, packet.getX(), packet.getY(), packet.getZ(), vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
        }
    }
}

