/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.mixin;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.UmbralTrespassData;
import net.soulsweaponry.items.DetonateGroundItem;
import net.soulsweaponry.items.IUltraHeavy;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.ModifyDamageUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"modifyAppliedDamage"}, at={@At(value="TAIL")}, cancellable=true)
    protected void modifyAppliedDamage(DamageSource source, float amount, CallbackInfoReturnable<Float> info) {
        LivingEntity entity = (LivingEntity)this;
        float newAmount = ((Float)info.getReturnValue()).floatValue();
        info.setReturnValue((Object)Float.valueOf(ModifyDamageUtil.modifyDamageTaken(entity, newAmount, source)));
    }

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptHeal(float amount, CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_21023_((MobEffect)EffectRegistry.DISABLE_HEAL.get())) {
            info.cancel();
        }
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptFallDamage(float fallDistance, float damageMultiplier, DamageSource source, CallbackInfoReturnable<Boolean> info) {
        LivingEntity entity = (LivingEntity)this;
        if (!(entity instanceof Player) && DetonateGroundItem.triggerCalculateFall(entity, fallDistance, source)) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"onDismounted"}, at={@At(value="HEAD")})
    public void interceptDismount(Entity entity, CallbackInfo info) {
        LivingEntity thisEntity = (LivingEntity)this;
        if (!thisEntity.m_9236_().f_46443_ && entity instanceof LivingEntity) {
            Player player;
            LivingEntity target = (LivingEntity)entity;
            if (thisEntity instanceof Player && UmbralTrespassData.shouldDamageRiding((LivingEntity)(player = (Player)thisEntity))) {
                float damage = UmbralTrespassData.getAbilityDamage((LivingEntity)player);
                boolean shouldHeal = UmbralTrespassData.shouldAbilityHeal((LivingEntity)player);
                if (shouldHeal) {
                    float healing = (damage += target.m_21233_() * (ConfigConstructor.darkin_scythe_prime_ability_percent_health_damage / 100.0f)) * ConfigConstructor.darkin_scythe_prime_heal_modifier;
                    player.m_5634_(healing);
                }
                player.m_21195_(MobEffects.f_19609_);
                player.m_21195_((MobEffect)EffectRegistry.GHOSTLY.get());
                target.m_6469_(player.m_9236_().m_269111_().m_269333_((LivingEntity)player), damage);
                UmbralTrespassData.setShouldDamageRiding((LivingEntity)player, false);
                if (!player.m_9236_().f_46443_ && player.m_20183_() != null) {
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.SLICE_TARGET_EVENT.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
                    ParticleHandler.particleOutburstMap(player.m_9236_(), 150, player.m_20185_(), player.m_20188_(), player.m_20189_(), ParticleEvents.SOUL_FLAME_SMALL_OUTBURST_MAP, 1.0f);
                }
            }
        }
    }

    @Inject(method={"disablesShield"}, at={@At(value="HEAD")}, cancellable=true)
    private void interceptDisablesShield(CallbackInfoReturnable<Boolean> info) {
        if (ConfigConstructor.ultra_heavy_disables_shields) {
            IUltraHeavy item;
            LivingEntity entity = (LivingEntity)this;
            Item item2 = entity.m_21205_().m_41720_();
            info.setReturnValue((Object)(item2 instanceof IUltraHeavy && (item = (IUltraHeavy)item2).isHeavy() ? 1 : 0));
            info.cancel();
        }
    }
}

