/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.NightsEdge;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.WeaponUtil;

public class NightsEdgeItem
extends ChargeToUseItem
implements IKeybindAbility {
    public NightsEdgeItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.nights_edge_weapon_damage, ConfigConstructor.nights_edge_weapon_attack_speed, settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.NIGHTS_EDGE, WeaponUtil.TooltipAbilities.BLIGHT);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_nights_edge;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        if (target.m_21023_((MobEffect)EffectRegistry.BLIGHT.get())) {
            int amp = target.m_21124_((MobEffect)EffectRegistry.BLIGHT.get()).m_19564_();
            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLIGHT.get(), 60, amp + 1));
            if (amp >= 10) {
                target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.DECAY.get(), 80, 0));
            }
        } else {
            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLIGHT.get(), 60, Mth.m_14143_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f))));
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        int i;
        Player player;
        if (user instanceof Player && !(player = (Player)user).m_36335_().m_41519_((Item)this) && (i = this.getChargeTime(stack, remainingUseTicks)) >= 10) {
            stack.m_41622_(1, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
            this.castSpell(player, world, stack, false);
            this.applyItemCooldown(player, this.getScaledCooldown(stack));
        }
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (!player.m_36335_().m_41519_((Item)this)) {
            this.castSpell(player, (Level)world, stack, true);
            this.applyItemCooldown(player, this.getScaledCooldown(stack));
            stack.m_41622_(1, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(player.m_7655_()));
        }
    }

    protected int getScaledCooldown(ItemStack stack) {
        int base = ConfigConstructor.nights_edge_ability_cooldown;
        return Math.max(ConfigConstructor.nights_edge_ability_min_cooldown, base - this.getReduceCooldownEnchantLevel(stack) * 8);
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.nights_edge_enchant_reduces_cooldown;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return ConfigConstructor.nights_edge_enchant_reduces_cooldown_id;
    }

    protected void castSpell(Player user, Level world, ItemStack stack, boolean ripple) {
        Vec3 start = user.m_20182_();
        double maxY = user.m_20186_();
        double y = user.m_20186_() + 1.0;
        float f = (float)Math.toRadians(user.m_146908_() + 90.0f);
        if (ripple) {
            for (int waves = 0; waves < 3 + Mth.m_14143_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f)); ++waves) {
                for (int i = 0; i < 360; i += Mth.m_14143_((float)(80.0f / ((float)waves + 1.0f)))) {
                    float r = 1.5f + (float)waves * 1.75f;
                    float yaw = (float)((double)f + (double)i * Math.PI / 180.0);
                    double x0 = start.m_7096_();
                    double z0 = start.m_7094_();
                    double x = x0 + (double)r * Math.cos((double)i * Math.PI / 180.0);
                    double z = z0 + (double)r * Math.sin((double)i * Math.PI / 180.0);
                    this.conjureFangs(user, world, stack, x, z, maxY, y, yaw, 3 * (waves + 1));
                }
            }
        } else {
            for (int i = 0; i < 10 + 2 * WeaponUtil.getEnchantDamageBonus(stack); ++i) {
                double h = 1.25 * (double)(i + 1);
                this.conjureFangs(user, world, stack, user.m_20185_() + (double)Mth.m_14089_((float)f) * h, user.m_20189_() + (double)Mth.m_14031_((float)f) * h, maxY, y, f, i);
            }
        }
    }

    private void conjureFangs(Player user, Level world, ItemStack stack, double x, double z, double maxY, double y, float yaw, int warmup) {
        BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
        boolean bl = false;
        double d = 0.0;
        do {
            VoxelShape voxelShape;
            BlockPos blockPos2;
            if (!world.m_8055_(blockPos2 = blockPos.m_7495_()).m_60783_((BlockGetter)world, blockPos2, Direction.UP)) continue;
            if (!world.m_46859_(blockPos) && !(voxelShape = world.m_8055_(blockPos).m_60812_((BlockGetter)world, blockPos)).m_83281_()) {
                d = voxelShape.m_83297_(Direction.Axis.Y);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
        if (bl) {
            NightsEdge edge = new NightsEdge((EntityType<? extends NightsEdge>)((EntityType)EntityRegistry.NIGHTS_EDGE.get()), world);
            edge.setOwner((LivingEntity)user);
            edge.setDamage(ConfigConstructor.nights_edge_ability_damage + (float)(2 * WeaponUtil.getEnchantDamageBonus(stack)));
            edge.setWarmup(warmup);
            edge.m_146922_(yaw * 57.295776f);
            edge.m_20343_(x, (double)blockPos.m_123342_() + d, z);
            world.m_7967_((Entity)edge);
        }
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, LocalPlayer player) {
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_nights_edge;
    }
}

