/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.items.BluemoonGreatsword;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.WeaponUtil;

public class MoonlightGreatsword
extends ChargeToUseItem {
    public MoonlightGreatsword(Tier toolMaterial, Item.Properties settings) {
        this(toolMaterial, ConfigConstructor.moonlight_greatsword_damage, ConfigConstructor.moonlight_greatsword_attack_speed, settings);
    }

    public MoonlightGreatsword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.MOONLIGHT);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_moonlight_greatsword;
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int i = this.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                stack.m_41622_(3, (LivingEntity)playerEntity, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
                MoonlightProjectile entity = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE.get()), world, user);
                entity.setAgeAndPoints(30, 150, 4);
                entity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 1.5f, 1.0f);
                entity.m_36781_(ConfigConstructor.moonlight_greatsword_projectile_damage);
                world.m_7967_((Entity)entity);
                world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (this instanceof BluemoonGreatsword && stack.m_41782_() && !playerEntity.m_7500_()) {
                    stack.m_41783_().m_128405_("current_charge", 0);
                }
            }
        }
    }

    @Override
    public Component[] getAdditionalTooltips() {
        return new Component[]{Component.m_237115_((String)"tooltip.soulsweapons.moonlight_greatsword.part_1").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.moonlight_greatsword.part_2").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.moonlight_greatsword.part_3").m_130940_(ChatFormatting.DARK_GRAY)};
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_moonlight_greatsword;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return null;
    }
}

