/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.WeaponUtil;

public class MasterSword
extends ChargeToUseItem {
    public MasterSword(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.master_sword_damage, ConfigConstructor.master_sword_attack_speed, settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.SKYWARD_STRIKES, WeaponUtil.TooltipAbilities.RIGHTEOUS);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int i = this.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                stack.m_41622_(1, (LivingEntity)playerEntity, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
                MoonlightProjectile entity = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE.get()), world, user);
                entity.setAgeAndPoints(30, 150, 4);
                entity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 1.5f, 1.0f);
                entity.m_36781_(ConfigConstructor.master_sword_projectile_damage);
                entity.setItemStack(stack);
                world.m_7967_((Entity)entity);
                world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (user.m_21223_() < user.m_21233_()) {
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_master_sword;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_master_sword;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return null;
    }
}

