/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.DragonslayerSwordspearEntity;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.util.WeaponUtil;

public class DragonslayerSwordspear
extends ChargeToUseItem {
    private static final String RAINING = "raining_id";

    public DragonslayerSwordspear(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.dragonslayer_swordspear_damage, ConfigConstructor.dragonslayer_swordspear_attack_speed, settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.LIGHTNING_CALL, WeaponUtil.TooltipAbilities.INFINITY, WeaponUtil.TooltipAbilities.THROW_LIGHTNING, WeaponUtil.TooltipAbilities.STORM_STOMP, WeaponUtil.TooltipAbilities.WEATHERBORN);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int i = this.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                if (stack == user.m_21206_() || WeaponUtil.isModLoaded("epicfight") && user.m_6144_()) {
                    stack.m_41622_(3, (LivingEntity)playerEntity, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
                    user.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, 5));
                    user.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 0));
                    AABB chunkBox = new AABB(user.m_20185_() - 10.0, user.m_20186_() - 5.0, user.m_20189_() - 10.0, user.m_20185_() + 10.0, user.m_20186_() + 5.0, user.m_20189_() + 10.0);
                    List nearbyEntities = world.m_45933_((Entity)user, chunkBox);
                    for (Entity nearbyEntity : nearbyEntities) {
                        TamableAnimal tamed;
                        if (!(nearbyEntity instanceof LivingEntity)) continue;
                        LivingEntity target = (LivingEntity)nearbyEntity;
                        if (nearbyEntity instanceof TamableAnimal && (tamed = (TamableAnimal)nearbyEntity).m_21824_()) continue;
                        if (world.m_45527_(target.m_20183_())) {
                            for (i = 0; i < ConfigConstructor.dragonslayer_swordspear_lightning_amount; ++i) {
                                LightningBolt entity = new LightningBolt(EntityType.f_20465_, world);
                                entity.m_20343_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                                world.m_7967_((Entity)entity);
                            }
                        } else {
                            double x = target.m_20185_() - user.m_20185_();
                            double z = target.m_20185_() - user.m_20185_();
                            target.m_147240_(5.0, -x, -z);
                            target.m_6469_(world.m_269111_().m_269333_(user), ConfigConstructor.dragonslayer_swordspear_ability_damage);
                            if (!world.f_46443_) {
                                ParticleHandler.particleSphereList(world, 20, target.m_20185_(), target.m_20186_(), target.m_20189_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
                            }
                        }
                        world.m_5594_(null, user.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    this.applyItemCooldown(playerEntity, this.getScaledCooldownAbility(world, stack));
                } else {
                    stack.m_41622_(1, (LivingEntity)playerEntity, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
                    DragonslayerSwordspearEntity entity = new DragonslayerSwordspearEntity(world, (LivingEntity)playerEntity, stack);
                    entity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 5.0f, 1.0f);
                    entity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    world.m_7967_((Entity)entity);
                    world.m_6269_(null, (Entity)entity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.applyItemCooldown(playerEntity, this.getScaledCooldownThrow(world, stack));
                }
            }
        }
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.dragonslayer_swordspear_enchant_reduces_cooldown;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return ConfigConstructor.dragonslayer_swordspear_enchant_reduces_cooldown_id;
    }

    protected int getScaledCooldownAbility(Level world, ItemStack stack) {
        int base = ConfigConstructor.dragonslayer_swordspear_ability_cooldown;
        return Math.max(ConfigConstructor.dragonslayer_swordspear_ability_min_cooldown, base - this.getReduceCooldownEnchantLevel(stack) * 20 / (world.m_46471_() ? 2 : 1));
    }

    protected int getScaledCooldownThrow(Level world, ItemStack stack) {
        int base = ConfigConstructor.dragonslayer_swordspear_throw_cooldown;
        return Math.max(ConfigConstructor.dragonslayer_swordspear_throw_min_cooldown, base - this.getReduceCooldownEnchantLevel(stack) * 10 / (world.m_46471_() ? 2 : 1));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!this.isDisabled(stack)) {
            this.updateRaining(world, stack);
        }
    }

    private void updateRaining(Level world, ItemStack stack) {
        if (stack.m_41782_()) {
            stack.m_41783_().m_128379_(RAINING, world.m_46471_());
        }
    }

    private boolean getRaining(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(RAINING) && !this.isDisabled(stack)) {
            return stack.m_41783_().m_128471_(RAINING);
        }
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND && this.getRaining(stack)) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(ConfigConstructor.dragonslayer_swordspear_damage + ConfigConstructor.dragonslayer_swordspear_rain_bonus_damage - 1), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)(-(4.0f - ConfigConstructor.dragonslayer_swordspear_rain_total_attack_speed)), AttributeModifier.Operation.ADDITION));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_dragonslayer_swordspear;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_dragonslayer_swordspear;
    }
}

