/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.GunItem;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.ItemRegistry;

public class Blunderbuss
extends GunItem {
    public Blunderbuss(Item.Properties settings) {
        super(settings);
    }

    @Override
    public int getPostureLoss(ItemStack stack) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.VISCERAL, (ItemStack)stack);
        return ConfigConstructor.blunderbuss_posture_loss + lvl * 2;
    }

    @Override
    public float getBulletDamage(ItemStack stack) {
        return ConfigConstructor.blunderbuss_damage;
    }

    @Override
    public float getBulletVelocity(ItemStack stack) {
        return ConfigConstructor.blunderbuss_velocity;
    }

    @Override
    public float getBulletDivergence(ItemStack stack) {
        return ConfigConstructor.blunderbuss_divergence;
    }

    @Override
    public int getCooldown(ItemStack stack) {
        return ConfigConstructor.blunderbuss_cooldown - this.getReducedCooldown(stack);
    }

    @Override
    public int bulletsNeeded() {
        return ConfigConstructor.blunderbuss_bullets_needed;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_blunderbuss;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (this.isDisabled(stack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        boolean bl = user.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
        ItemStack itemStack = user.m_6298_(stack);
        if (!itemStack.m_41619_() || bl) {
            if (itemStack.m_41619_()) {
                itemStack = new ItemStack((ItemLike)ItemRegistry.SILVER_BULLET.get());
            }
            boolean bl2 = bl && itemStack.m_150930_((Item)ItemRegistry.SILVER_BULLET.get());
            int projectileCount = ConfigConstructor.blunderbuss_projectile_amount + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack) / 2;
            Vec3 pov = user.m_20154_();
            Vec3 particleBox = pov.m_82490_(1.0).m_82549_(user.m_20182_());
            for (int i = 0; i < projectileCount; ++i) {
                AbstractArrow entity = this.createSilverBulletEntity(world, (LivingEntity)user, stack);
                world.m_7967_((Entity)entity);
            }
            if (world.f_46443_) {
                for (int k = 0; k < 50; ++k) {
                    world.m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, particleBox.f_82479_, particleBox.f_82480_ + 1.5, particleBox.f_82481_, pov.f_82479_ + user.m_217043_().m_188500_() - 0.5, pov.f_82480_ + user.m_217043_().m_188500_() - 0.5, pov.f_82481_ + user.m_217043_().m_188500_() - 0.5);
                    world.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, particleBox.f_82479_, particleBox.f_82480_ + 1.5, particleBox.f_82481_, pov.f_82479_ + user.m_217043_().m_188500_() - 0.5, pov.f_82480_ + user.m_217043_().m_188500_() - 0.5, pov.f_82481_ + user.m_217043_().m_188500_() - 0.5);
                }
            }
            world.m_5594_(user, user.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
            stack.m_41622_(1, (LivingEntity)user, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
            if (!bl2 && !user.m_150110_().f_35937_) {
                itemStack.m_41774_(this.bulletsNeeded());
                if (itemStack.m_41619_()) {
                    user.m_150109_().m_36057_(itemStack);
                }
            }
            user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!user.m_7500_()) {
                user.m_36335_().m_41524_((Item)this, this.getCooldown(stack));
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_hunter_blunderbuss;
    }
}

