/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.MoonlightGreatsword;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.WeaponUtil;

public class BluemoonGreatsword
extends MoonlightGreatsword
implements IChargeNeeded {
    public BluemoonGreatsword(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.bluemoon_greatsword_damage, ConfigConstructor.bluemoon_greatsword_attack_speed, settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.NEED_CHARGE, WeaponUtil.TooltipAbilities.CHARGE);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_bluemoon_greatsword;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        this.addCharge(stack, this.getAddedCharge(stack));
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (this.isDisabled(itemStack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        if (itemStack.m_41773_() < itemStack.m_41776_() - 1 && (this.isCharged(itemStack) || user.m_7500_() || user.m_21023_((MobEffect)EffectRegistry.MOON_HERALD.get()))) {
            user.m_6672_(hand);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    @Override
    public int getMaxCharge() {
        return ConfigConstructor.bluemoon_greatsword_charge_needed;
    }

    @Override
    public int getAddedCharge(ItemStack stack) {
        return ConfigConstructor.bluemoon_greatsword_charge_added_post_hit;
    }

    @Override
    public Component[] getAdditionalTooltips() {
        return new Component[0];
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_bluemoon_greatsword;
    }
}

