/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimatableManager;

public abstract class AbstractDawnbreaker
extends ChargeToUseItem
implements GeoItem {
    public AbstractDawnbreaker(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.DAWNBREAKER, WeaponUtil.TooltipAbilities.BLAZING_BLADE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        target.m_20254_(4 + 3 * EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack));
        if (target.m_21222_() || ConfigConstructor.dawnbreaker_affect_all_entities) {
            if (target.m_21224_() && target.m_21023_((MobEffect)EffectRegistry.RETRIBUTION.get())) {
                double chance = ConfigConstructor.dawnbreaker_ability_percent_chance_addition + 1.0 - Math.pow(0.75, target.m_21124_((MobEffect)EffectRegistry.RETRIBUTION.get()).m_19564_());
                double random = target.m_217043_().m_188500_();
                if (random < chance) {
                    AbstractDawnbreaker.dawnbreakerEvent(target, attacker, stack);
                }
            }
            if (target.m_21023_((MobEffect)EffectRegistry.RETRIBUTION.get())) {
                int amplifier = target.m_21124_((MobEffect)EffectRegistry.RETRIBUTION.get()).m_19564_();
                target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.RETRIBUTION.get(), 80, amplifier + 1));
            } else {
                target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.RETRIBUTION.get(), 80, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack)));
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public static void dawnbreakerEvent(LivingEntity target, LivingEntity attacker, ItemStack stack) {
        if (!attacker.m_9236_().f_46443_ && attacker instanceof ServerPlayer) {
            ParticleHandler.particleSphere(attacker.m_9236_(), 1000, target.m_20185_(), target.m_20188_() - 0.25, target.m_20189_(), (ParticleOptions)ParticleTypes.f_123744_, 1.0f);
            ParticleHandler.particleOutburstMap(attacker.m_9236_(), 200, target.m_20185_(), target.m_20186_(), target.m_20189_(), ParticleEvents.DAWNBREAKER_MAP, 1.0f);
        }
        target.m_9236_().m_5594_(null, target.m_20183_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
        AABB aoe = target.m_20191_().m_82400_(10.0);
        List entities = attacker.m_9236_().m_45933_((Entity)target, aoe);
        boolean bl = ConfigConstructor.dawnbreaker_affect_all_entities;
        for (Entity entity : entities) {
            LivingEntity targetHit;
            if (!(entity instanceof LivingEntity) || !(targetHit = (LivingEntity)entity).m_21222_() && !bl || targetHit.equals((Object)attacker)) continue;
            targetHit.m_20254_(4 + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack));
            targetHit.m_6469_(attacker.m_9236_().m_269111_().m_269036_(null, (Entity)attacker), ConfigConstructor.dawnbreaker_ability_damage + (float)(5 * EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack)));
            targetHit.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FEAR.get(), 80, 0));
        }
    }
}

