/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.ReturningProjectileDataSyncS2C;
import org.jetbrains.annotations.Nullable;

public class ReturningProjectileData {
    public static final String PROJECTILE_ID = "returning_projectile_uuid";

    @Nullable
    public static UUID getReturningProjectileUuid(LivingEntity entity) {
        if (!entity.getPersistentData().m_128441_(PROJECTILE_ID)) {
            return null;
        }
        return entity.getPersistentData().m_128342_(PROJECTILE_ID);
    }

    public static UUID setReturningProjectileUuid(LivingEntity entity, UUID uuid) {
        CompoundTag nbt = entity.getPersistentData();
        nbt.m_128362_(PROJECTILE_ID, uuid);
        if (entity instanceof ServerPlayer) {
            ReturningProjectileData.syncData(uuid, (ServerPlayer)entity);
        }
        return uuid;
    }

    public static void syncData(UUID uuid, ServerPlayer entity) {
        ModMessages.sendToPlayer(new ReturningProjectileDataSyncS2C(uuid), entity);
    }
}

