/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.FreyrSwordSummonDataSyncS2C;
import org.jetbrains.annotations.Nullable;

public class FreyrSwordSummonData {
    public static final String SUMMON_ID = "freyr_sword_summon_uuid";

    @Nullable
    public static UUID getSummonUuid(LivingEntity entity) {
        if (!entity.getPersistentData().m_128441_(SUMMON_ID)) {
            return null;
        }
        return entity.getPersistentData().m_128342_(SUMMON_ID);
    }

    public static UUID setSummonUuid(LivingEntity entity, UUID uuid) {
        CompoundTag nbt = entity.getPersistentData();
        nbt.m_128362_(SUMMON_ID, uuid);
        if (entity instanceof ServerPlayer) {
            FreyrSwordSummonData.syncData(uuid, (ServerPlayer)entity);
        }
        return uuid;
    }

    public static void syncData(UUID uuid, ServerPlayer entity) {
        ModMessages.sendToPlayer(new FreyrSwordSummonDataSyncS2C(uuid), entity);
    }
}

