/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.registry.ParticleRegistry;

public class DeathSpiralLogic {
    private final Vec3 pos;
    private final float radius;
    private int age;
    private boolean switchParticle = true;
    private final List<List<Vec3>> spirals;

    public DeathSpiralLogic(Vec3 pos, float radius) {
        this.pos = pos;
        this.radius = radius;
        this.spirals = this.getSpirals();
    }

    public void tick(Level world, Vec3 origin) {
        ++this.age;
        if (world.f_46443_) {
            for (List<Vec3> list : this.spirals) {
                if (list.size() == 0) continue;
                ParticleOptions type = this.switchParticle ? (ParticleOptions)ParticleRegistry.DAZZLING_PARTICLE.get() : (ParticleOptions)ParticleRegistry.DARK_STAR.get();
                Vec3 vec = new Vec3(list.get(0).m_7096_(), list.get(0).m_7098_(), list.get(0).m_7094_()).m_82549_(origin);
                world.m_7106_(type, vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 0.0, 0.0, 0.0);
                this.switchParticle = !this.switchParticle;
                list.remove(0);
            }
        }
    }

    private List<List<Vec3>> getSpirals() {
        ArrayList<Vec3> list1 = new ArrayList<Vec3>();
        ArrayList<Vec3> list2 = new ArrayList<Vec3>();
        ArrayList<List<Vec3>> list3 = new ArrayList<List<Vec3>>();
        float r = this.radius;
        for (int theta = 0; theta < 360; ++theta) {
            if (theta % 2 != 0) continue;
            double x0 = this.pos.m_7096_();
            double y0 = this.pos.m_7098_() + 3.0;
            double z0 = this.pos.m_7094_();
            double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
            double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
            list1.add(new Vec3(x, this.pos.m_7098_() + (double)theta * Math.PI / 180.0, z));
            list2.add(new Vec3(x, y0 + (double)r * Math.tan((double)theta * Math.PI / 180.0), z));
        }
        list3.add(list1);
        list3.add(list2);
        return list3;
    }

    public boolean isFinished() {
        int i = 0;
        for (List<Vec3> list : this.spirals) {
            i += list.size();
        }
        return i == 0;
    }
}

