/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.invisible;

import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.invisible.InvisibleWarmupEntity;
import net.soulsweaponry.registry.SoundRegistry;

public class HolyMoonlightPillar
extends InvisibleWarmupEntity {
    private float knockUp = ConfigConstructor.holy_moonlight_ability_knockup;
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(HolyMoonlightPillar.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PARTICLE_MOD = SynchedEntityData.m_135353_(HolyMoonlightPillar.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public HolyMoonlightPillar(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARTICLE_MOD, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(1.85f));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setWarmup(this.getWarmup() - 1);
            if (this.getWarmup() < 0 && this.getWarmup() == -7) {
                List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.2));
                for (LivingEntity livingEntity : list) {
                    this.damage(livingEntity);
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.MOONLIGHT_SMALL_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                this.m_146870_();
            }
        }
    }

    public void m_142036_() {
        Random random = new Random();
        double d = random.nextGaussian() * 0.05;
        double e = random.nextGaussian() * 0.05;
        double f = random.nextGaussian() * 0.05;
        int j = 0;
        while ((float)j < 200.0f * this.getParticleMod()) {
            double newX = random.nextDouble() - 0.5 + random.nextGaussian() * 0.15 + d;
            double newZ = random.nextDouble() - 0.5 + random.nextGaussian() * 0.15 + e;
            double newY = random.nextDouble() - 0.5 + random.nextGaussian() * 0.5 + f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20186_(), this.m_20189_(), newX / 2.0, newY / 0.5, newZ / 2.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), newX / 2.0, newY / 0.5, newZ / 2.0);
            ++j;
        }
        super.m_142036_();
    }

    private void damage(LivingEntity target) {
        LivingEntity livingEntity;
        Entity entity = this.m_19749_();
        if (target.m_6084_() && !target.m_20147_() && entity instanceof LivingEntity && target != (livingEntity = (LivingEntity)entity) && !livingEntity.m_7307_((Entity)target)) {
            target.m_6469_(this.m_269291_().m_269333_((LivingEntity)entity), (float)this.m_36789_() + 2.0f * EnchantmentHelper.m_44833_((ItemStack)this.getStack(), (MobType)target.m_6336_()));
            target.m_5997_(0.0, (double)this.getKnockup(), 0.0);
        }
    }

    private float getKnockup() {
        return this.knockUp;
    }

    public void setKnockUp(float knockUp) {
        this.knockUp = knockUp;
    }

    public void setRadius(float radius) {
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
    }

    public void setParticleMod(float particleMod) {
        this.f_19804_.m_135381_(PARTICLE_MOD, (Object)Float.valueOf(particleMod));
    }

    public float getParticleMod() {
        return ((Float)this.f_19804_.m_135370_(PARTICLE_MOD)).floatValue();
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("Knockup")) {
            this.knockUp = nbt.m_128457_("Knockup");
        }
        if (nbt.m_128441_("Radius")) {
            this.setRadius(nbt.m_128457_("Radius"));
        }
        if (nbt.m_128441_("ParticleModifier")) {
            this.setParticleMod(nbt.m_128457_("ParticleModifier"));
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128350_("Knockup", this.knockUp);
        nbt.m_128350_("Radius", this.getRadius());
        nbt.m_128350_("ParticleModifier", this.getParticleMod());
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)this.getRadius(), (float)this.getRadius());
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (RADIUS.equals(data)) {
            this.m_6210_();
        }
        super.m_7350_(data);
    }
}

