/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.entitydata.ReturningProjectileData;
import org.jetbrains.annotations.Nullable;

public abstract class ReturningProjectile
extends AbstractArrow {
    public ItemStack stack;
    public boolean dealtDamage;
    private boolean shouldReturn;
    private int returnTimer;
    public static final String DEALT_DAMAGE = "DealtDamage";
    public static final String SHOULD_RETURN = "ShouldReturn";

    public ReturningProjectile(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public ReturningProjectile(EntityType<? extends AbstractArrow> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public ReturningProjectile(EntityType<? extends AbstractArrow> type, LivingEntity owner, Level world) {
        super(type, owner, world);
    }

    public ReturningProjectile(EntityType<? extends AbstractArrow> type, LivingEntity owner, Level world, ItemStack stack) {
        super(type, owner, world);
        this.stack = stack.m_41777_();
    }

    public abstract float getDamage(Entity var1);

    public abstract boolean collide(Entity var1, Entity var2, float var3);

    public abstract double getReturnSpeed(ItemStack var1);

    protected void m_5790_(EntityHitResult entityHitResult) {
        ReturningProjectile owner = this.m_19749_() == null ? this : this.m_19749_();
        Entity entity = entityHitResult.m_82443_();
        this.dealtDamage = true;
        if (this.collide((Entity)owner, entity, this.getDamage(entity))) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                if (owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)target, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)target);
                }
                this.m_7761_(target);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
    }

    public void saveOnPlayer(Player player) {
        UUID uuid = this.m_20148_();
        UUID prevUuid = ReturningProjectileData.getReturningProjectileUuid((LivingEntity)player);
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverWorld = (ServerLevel)level;
            if (prevUuid == null) {
                ReturningProjectileData.setReturningProjectileUuid((LivingEntity)player, uuid);
                prevUuid = uuid;
            }
            if ((entity = serverWorld.m_8791_(prevUuid)) instanceof ReturningProjectile) {
                ReturningProjectile returning = (ReturningProjectile)entity;
                returning.setShouldReturn(true);
            }
            ReturningProjectileData.setReturningProjectileUuid((LivingEntity)player, uuid);
        }
    }

    public void m_8119_() {
        if (this.f_36704_ > 4 || this.f_19797_ > 60) {
            this.dealtDamage = true;
        }
        if (!this.f_36703_ && this.f_19797_ > 60) {
            this.setShouldReturn(true);
        }
        Entity owner = this.m_19749_();
        double returnSpeed = this.getReturnSpeed(this.stack);
        if (this.shouldReturn() && (this.dealtDamage || this.m_36797_()) && owner != null) {
            this.m_36790_(true);
            Vec3 vec3d = owner.m_146892_().m_82546_(this.m_20182_());
            if (!this.isOwnerAlive()) {
                if (this.stack.m_41782_() && this.stack.m_41783_().m_128441_("owners_last_pos")) {
                    int[] pos = this.stack.m_41783_().m_128465_("owners_last_pos");
                    vec3d = new Vec3((double)pos[0], (double)pos[1], (double)pos[2]).m_82546_(this.m_20182_());
                    if (vec3d.m_7096_() == (double)pos[0] && vec3d.m_7098_() == (double)pos[1] && vec3d.m_7094_() == (double)pos[2]) {
                        this.dropStack();
                    }
                } else {
                    this.dropStack();
                }
            }
            this.m_20343_(this.m_20185_(), this.m_20186_() + vec3d.f_82480_ * 0.015 * returnSpeed, this.m_20189_());
            if (this.m_9236_().f_46443_) {
                this.f_19791_ = this.m_20186_();
            }
            double d = 0.05 * returnSpeed;
            this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3d.m_82541_().m_82490_(d)));
            if (this.returnTimer == 0) {
                this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
            }
            ++this.returnTimer;
            for (Entity entity1 : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(0.2))) {
                LivingEntity target;
                if (!(entity1 instanceof LivingEntity) || (target = (LivingEntity)entity1).m_7307_(owner)) continue;
                this.collide(owner, (Entity)target, this.getDamage((Entity)target));
            }
        }
        List<Entity> list = this.m_9236_().m_45933_((Entity)this, this.m_20191_()).stream().filter(e -> e instanceof Player).toList();
        if (this.dealtDamage && !list.isEmpty()) {
            Player player = (Player)list.get(0);
            if (owner != null) {
                for (Entity entity1 : list) {
                    if (!entity1.equals((Object)owner)) continue;
                    player = (Player)entity1;
                }
            }
            if (this.m_19749_() == null) {
                this.insertStack(player);
            } else if (this.m_150171_((Entity)player)) {
                this.insertStack(player);
            }
        }
        super.m_8119_();
    }

    public void insertStack(Player player) {
        boolean inserted;
        int slot = player.m_150109_().f_35977_;
        if (!player.m_150109_().m_36056_().m_41619_()) {
            slot = -1;
        }
        if (inserted = player.m_150109_().m_36040_(slot, this.m_7941_())) {
            player.m_5496_(SoundEvents.f_12019_, 1.0f, (float)this.f_19796_.m_188583_() + 0.25f);
        }
        if (!inserted) {
            this.m_5552_(this.m_7941_(), 0.1f);
        }
        this.m_146870_();
    }

    private void dropStack() {
        if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
            this.m_5552_(this.m_7941_(), 0.1f);
        }
        this.m_146870_();
    }

    public boolean shouldReturn() {
        return this.shouldReturn;
    }

    public boolean m_5825_() {
        return true;
    }

    public void setShouldReturn(boolean bl) {
        this.dealtDamage = bl;
        this.shouldReturn = bl;
        this.m_36790_(bl);
    }

    private boolean isOwnerAlive() {
        Entity entity = this.m_19749_();
        if (entity == null || !entity.m_6084_()) {
            return false;
        }
        return !(entity instanceof ServerPlayer) || !entity.m_5833_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 currentPosition, Vec3 nextPosition) {
        if (this.dealtDamage) {
            return null;
        }
        return super.m_6351_(currentPosition, nextPosition);
    }

    public int getReturnTimer() {
        return this.returnTimer;
    }

    protected boolean m_142470_(Player player) {
        int slot = player.m_150109_().f_35977_;
        if (!player.m_150109_().m_36056_().m_41619_()) {
            slot = -1;
        }
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36040_(slot, this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Stack", 10)) {
            this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Stack"));
        }
        if (nbt.m_128441_(SHOULD_RETURN)) {
            this.shouldReturn = nbt.m_128471_(SHOULD_RETURN);
        }
        if (nbt.m_128441_("ReturnTimer")) {
            this.returnTimer = nbt.m_128451_("ReturnTimer");
        }
        this.dealtDamage = nbt.m_128471_(DEALT_DAMAGE);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("Stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        nbt.m_128379_(DEALT_DAMAGE, this.dealtDamage);
        nbt.m_128379_(SHOULD_RETURN, this.shouldReturn);
        nbt.m_128405_("ReturnTimer", this.returnTimer);
    }

    public ItemStack m_7941_() {
        return this.stack;
    }

    protected float m_6882_() {
        return 0.99f;
    }
}

