/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.LeviathanAxeEntity;
import net.soulsweaponry.entity.projectile.ReturningProjectile;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class MjolnirProjectile
extends ReturningProjectile
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public MjolnirProjectile(EntityType<? extends MjolnirProjectile> entityType, Level world) {
        super(entityType, world);
        this.stack = new ItemStack((ItemLike)WeaponRegistry.MJOLNIR.get());
    }

    public MjolnirProjectile(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MJOLNIR_ENTITY_TYPE.get()), owner, world);
        this.stack = stack.m_41777_();
    }

    @Override
    public double getReturnSpeed(ItemStack stack) {
        return ConfigConstructor.mjolnir_return_speed + (double)WeaponUtil.getEnchantDamageBonus(this.m_7941_()) / 2.0;
    }

    @Override
    public float getDamage(Entity target) {
        float f = ConfigConstructor.mjolnir_projectile_damage;
        if (target instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_7941_(), (MobType)((LivingEntity)target).m_6336_());
        }
        return f;
    }

    @Override
    public boolean collide(Entity owner, Entity target, float damage) {
        DamageSource damageSource = this.m_9236_().m_269111_().m_269525_((Entity)this, owner);
        SoundEvent soundEvent = SoundEvents.f_12514_;
        float g = 1.0f;
        boolean bl = target.m_6469_(damageSource, damage);
        int strikes = 1;
        if (this.m_9236_().m_46470_() || target instanceof LeviathanAxeEntity) {
            strikes = 3;
        }
        if (bl && this.m_9236_() instanceof ServerLevel) {
            BlockPos blockPos = target.m_20183_();
            if (this.m_9236_().m_45527_(blockPos)) {
                for (int i = 0; i < strikes; ++i) {
                    LightningBolt lightningEntity = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                    lightningEntity.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
                    lightningEntity.m_20879_(owner instanceof ServerPlayer ? (ServerPlayer)owner : null);
                    this.m_9236_().m_7967_((Entity)lightningEntity);
                }
                soundEvent = SoundEvents.f_12521_;
                g = 5.0f;
            }
        }
        this.m_5496_(soundEvent, g, 1.0f);
        return bl;
    }

    protected boolean m_5603_(Entity entity) {
        if (entity instanceof LeviathanAxeEntity) {
            return true;
        }
        return super.m_5603_(entity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

