/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.soulsweaponry.registry.SoundRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WarmthEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> STATES = SynchedEntityData.m_135353_(WarmthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public WarmthEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new WarmthEntityGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> !this.m_21824_() || !(this.m_269323_() instanceof Player)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, entity -> this.m_21824_() && entity instanceof Enemy && !(entity instanceof Creeper) && !this.m_7307_((Entity)entity)));
    }

    private PlayState attacks(AnimationState<?> state) {
        switch (this.getState()) {
            case 1: {
                state.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.LOOP));
                break;
            }
            case 2: {
                state.getController().setAnimation(RawAnimation.begin().then("buff", Animation.LoopType.LOOP));
                break;
            }
            default: {
                state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATES, (Object)state);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATES);
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATES, (Object)0);
    }

    public static AttributeSupplier.Builder createEntityAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 30.0);
    }

    public EntityGetter m_9236_() {
        return super.m_9236_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public boolean m_6094_() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacks", 0, this::attacks)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        if (this.m_9236_().f_46443_) {
            this.particleExplosion();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 1200) {
            this.m_6074_();
        }
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (this.m_9236_().f_46443_) {
            this.particleExplosion();
        }
        this.m_146870_();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.WARMTH_DIE_EVENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12032_;
    }

    public boolean m_6126_() {
        return true;
    }

    private void particleExplosion() {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        float points = 100.0f;
        int i = 0;
        while ((float)i < points) {
            double velocityY = 1.0f - (float)i / (points - 1.0f) * 2.0f;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), velocityX * (double)0.4f, velocityY * (double)0.4f, velocityZ * (double)0.4f);
            ++i;
        }
    }

    static class WarmthEntityGoal
    extends Goal {
        private final WarmthEntity entity;
        private int attackCooldown;
        private int attackStatus;

        public WarmthEntityGoal(WarmthEntity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.entity.m_5448_();
            return livingEntity != null && livingEntity.m_6084_() && this.entity.m_6779_(livingEntity);
        }

        public void m_8041_() {
            this.reset();
        }

        private void reset() {
            this.entity.setState(0);
            this.attackCooldown = 60;
            this.attackStatus = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.attackCooldown;
            LivingEntity livingEntity = this.entity.m_5448_();
            if (livingEntity == null) {
                return;
            }
            this.entity.m_21563_().m_24960_((Entity)livingEntity, 10.0f, 10.0f);
            if (this.attackCooldown < 0 && this.entity.getState() == 0) {
                int rand = this.entity.f_19796_.m_188503_(5);
                this.entity.setState(rand == 1 ? 2 : 1);
            }
            switch (this.entity.getState()) {
                case 1: {
                    this.shootFire(livingEntity);
                    break;
                }
                case 2: {
                    this.buff();
                }
            }
        }

        private void shootFire(LivingEntity livingEntity) {
            ++this.attackStatus;
            double e = livingEntity.m_20185_() - this.entity.m_20185_();
            double f = livingEntity.m_20227_(0.5) - this.entity.m_20227_(0.5);
            double g = livingEntity.m_20189_() - this.entity.m_20189_();
            if (this.attackStatus == 7 || this.attackStatus == 15 || this.attackStatus == 21) {
                this.entity.m_9236_().m_5594_(null, this.entity.m_20183_(), SoundEvents.f_11705_, SoundSource.HOSTILE, 1.0f, 1.0f);
                SmallFireball smallFireballEntity = new SmallFireball(this.entity.m_9236_(), (LivingEntity)this.entity, e, f, g);
                smallFireballEntity.m_6034_(smallFireballEntity.m_20185_(), this.entity.m_20227_(0.5), smallFireballEntity.m_20189_());
                this.entity.m_9236_().m_7967_((Entity)smallFireballEntity);
            }
            if (this.attackStatus >= 28) {
                this.reset();
            }
        }

        private void buff() {
            ++this.attackStatus;
            if (this.attackStatus == 1) {
                this.entity.m_9236_().m_5594_(null, this.entity.m_20183_(), SoundEvents.f_12001_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.attackStatus == 30) {
                this.entity.m_9236_().m_5594_(null, this.entity.m_20183_(), (SoundEvent)SoundRegistry.WARMTH_BUFF_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.attackStatus == 35) {
                boolean bl = this.entity.m_21824_() && this.entity.m_269323_() != null;
                for (Entity en : this.entity.m_9236_().m_45933_((Entity)this.entity, this.entity.m_20191_().m_82400_(16.0))) {
                    if (!(en instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)en;
                    if (bl && !(living instanceof Monster)) {
                        this.addEffects(living);
                        continue;
                    }
                    if (!(living instanceof Enemy)) continue;
                    this.addEffects(living);
                }
                this.addEffects((LivingEntity)this.entity);
            }
            if (this.attackStatus >= 40) {
                this.reset();
            }
        }

        private void addEffects(LivingEntity living) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 0));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 0));
        }
    }
}

