/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.mobs.SoulReaperGhost;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import net.soulsweaponry.util.IAnimatedDeath;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Soulmass
extends Remnant
implements GeoEntity,
IAnimatedDeath {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private List<Integer> summonIds = new ArrayList<Integer>();
    private static final EntityDataAccessor<Boolean> CLAP = SynchedEntityData.m_135353_(Soulmass.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SMASH = SynchedEntityData.m_135353_(Soulmass.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> START_BEAM = SynchedEntityData.m_135353_(Soulmass.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STOP_BEAM = SynchedEntityData.m_135353_(Soulmass.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BEAMING = SynchedEntityData.m_135353_(Soulmass.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SACRIFICE = SynchedEntityData.m_135353_(Soulmass.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<BlockPos> BEAM_CORDS = SynchedEntityData.m_135353_(Soulmass.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public Soulmass(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 30;
    }

    private PlayState predicate(AnimationState<?> state) {
        if (this.getSacrifice()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("sacrifice"));
        } else if (this.getStartBeam()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("start_beam"));
        } else if (this.m_6144_()) {
            state.getController().setAnimation(RawAnimation.begin().then("start_beam", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else if (this.getStopBeam()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("stop_beam"));
        } else if (this.getBeaming()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("beaming"));
        } else if (this.getClap()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("clap"));
        } else if (this.getSmash()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("smash_ground"));
        } else {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        }
        return PlayState.CONTINUE;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new SoulmassGoal(this));
        super.m_8099_();
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    public int getSoulAmount() {
        return 30;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLAP, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(SMASH, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(START_BEAM, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(STOP_BEAM, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(BEAMING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(SACRIFICE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(BEAM_CORDS, (Object)new BlockPos(0, 0, 0));
    }

    public static AttributeSupplier.Builder createSoulmassAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    public void setClap(boolean bl) {
        this.f_19804_.m_135381_(CLAP, (Object)bl);
    }

    public boolean getClap() {
        return (Boolean)this.f_19804_.m_135370_(CLAP);
    }

    public void setSmash(boolean bl) {
        this.f_19804_.m_135381_(SMASH, (Object)bl);
    }

    public boolean getSmash() {
        return (Boolean)this.f_19804_.m_135370_(SMASH);
    }

    public void setStartBeam(boolean bl) {
        this.f_19804_.m_135381_(START_BEAM, (Object)bl);
    }

    public boolean getStartBeam() {
        return (Boolean)this.f_19804_.m_135370_(START_BEAM);
    }

    public void setStopBeam(boolean bl) {
        this.f_19804_.m_135381_(STOP_BEAM, (Object)bl);
    }

    public boolean getStopBeam() {
        return (Boolean)this.f_19804_.m_135370_(STOP_BEAM);
    }

    public void setBeaming(boolean bl) {
        this.f_19804_.m_135381_(BEAMING, (Object)bl);
    }

    public boolean getBeaming() {
        return (Boolean)this.f_19804_.m_135370_(BEAMING);
    }

    public void setSacrifice(boolean bl) {
        this.f_19804_.m_135381_(SACRIFICE, (Object)bl);
    }

    public boolean getSacrifice() {
        return (Boolean)this.f_19804_.m_135370_(SACRIFICE);
    }

    public void setBeamCords(double x, double y, double z) {
        this.f_19804_.m_135381_(BEAM_CORDS, (Object)BlockPos.m_274561_((double)x, (double)y, (double)z));
    }

    public BlockPos getBeamCords() {
        return (BlockPos)this.f_19804_.m_135370_(BEAM_CORDS);
    }

    public void resetAnimations() {
        this.setClap(false);
        this.setSmash(false);
        this.setBeaming(false);
        this.setStartBeam(false);
        this.setStopBeam(false);
    }

    @Override
    public int getTicksUntilDeath() {
        return 60;
    }

    @Override
    public void setDeath() {
        this.setSacrifice(true);
    }

    @Override
    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.setDeath();
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), new ParticleOptions[]{(ParticleOptions)ParticleRegistry.PURPLE_FLAME.get(), ParticleTypes.f_123745_, ParticleTypes.f_123755_});
            this.sacrificeEvent();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void sacrificeEvent() {
        AABB chunkBox = new AABB(this.m_20183_()).m_82400_(16.0);
        List nearbyEntities = this.m_9236_().m_45933_((Entity)this, chunkBox);
        for (Entity nearbyEntity : nearbyEntities) {
            if (!(nearbyEntity instanceof Monster)) continue;
            LivingEntity closestTarget = (LivingEntity)nearbyEntity;
            closestTarget.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 1));
            closestTarget.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, 1));
            closestTarget.m_6469_(this.m_9236_().m_269111_().m_269425_(), 16.0f);
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128408_("summon_ids", this.summonIds);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("summon_ids")) {
            this.summonIds = WeaponUtil.arrayToList(nbt.m_128465_("summon_ids"));
        }
    }

    public void addSummonIds(int id) {
        this.summonIds.add(id);
    }

    public boolean hasSummonsAlive() {
        if (!this.m_9236_().f_46443_) {
            for (int id : this.summonIds) {
                if (this.m_9236_().m_6815_(id) == null) continue;
                return true;
            }
        }
        this.summonIds.clear();
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6144_() && !this.m_21224_()) {
            this.soulCircle(this.m_9236_(), this.m_20185_(), this.m_20188_() + 1.0, this.m_20189_());
            if (this.m_21223_() < this.m_21233_()) {
                this.m_5634_(1.0f);
            }
        } else if (this.getBeaming()) {
            double e = (double)this.getBeamCords().m_123341_() - this.m_20185_();
            double f = (double)this.getBeamCords().m_123342_() - this.m_20188_();
            double g = (double)this.getBeamCords().m_123343_() - this.m_20189_();
            double h = Math.sqrt(e * e + f * f + g * g);
            e /= h;
            f /= h;
            g /= h;
            double j = this.f_19796_.m_188500_();
            for (int i = 0; i < 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_() + e * (j += 0.5 + this.f_19796_.m_188500_()), this.m_20188_() + 1.0 + f * j, this.m_20189_() + g * j, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_() + e * j, this.m_20188_() + 1.0 + f * j, this.m_20189_() + g * j, 0.0, 0.0, 0.0);
            }
            this.soulCircle(this.m_9236_(), this.m_20185_(), this.m_20188_() + 1.0, this.m_20189_());
        }
    }

    public void soulCircle(Level world, double x, double y, double z) {
        double points = 30.0;
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            world.m_6493_((ParticleOptions)ParticleTypes.f_123745_, true, x + velocityX / 2.0, y + velocityY / 2.0, z + velocityZ / 2.0, 0.0, 0.0, 0.0);
            ++i;
        }
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12557_;
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.SOULMASS_IDLE_EVENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12513_;
    }

    @Override
    public void initEquip() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    static class SoulmassGoal
    extends Goal {
        private final Soulmass entity;
        private int attackCooldown;
        private int attackStatus;
        private int uniqueCooldown;
        private int nextAttack = 0;

        public SoulmassGoal(Soulmass entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.m_6779_(target);
        }

        public void m_8041_() {
            super.m_8041_();
            this.entity.resetAnimations();
            this.entity.m_21561_(false);
            this.resetCooldowns(10, 10);
        }

        public void newAttack() {
            this.nextAttack = this.entity.f_19796_.m_188503_(5);
        }

        private void resetCooldowns(int uniqueCooldown, int attackCooldown) {
            this.attackCooldown = attackCooldown;
            this.uniqueCooldown = uniqueCooldown;
            this.attackStatus = 0;
            this.newAttack();
        }

        public void m_8037_() {
            LivingEntity target;
            if (this.attackCooldown > -1) {
                --this.attackCooldown;
            }
            if (this.uniqueCooldown > -1) {
                --this.uniqueCooldown;
            }
            if ((target = this.entity.m_5448_()) != null) {
                double distanceToEntity = this.entity.m_20280_((Entity)target);
                this.entity.m_21561_(true);
                this.entity.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
                if (this.attackCooldown < 0) {
                    if (this.nextAttack > 1) {
                        this.entity.setClap(true);
                    } else if (this.uniqueCooldown > 10) {
                        this.newAttack();
                    }
                    if (this.uniqueCooldown < 0) {
                        if (this.nextAttack == 0) {
                            this.entity.setStartBeam(true);
                            this.resetCooldowns(80, 50);
                        } else if (this.nextAttack == 1) {
                            if (!this.entity.hasSummonsAlive()) {
                                this.entity.setSmash(true);
                            } else {
                                this.entity.setSmash(false);
                                this.newAttack();
                            }
                        }
                    }
                }
                if (this.entity.getClap()) {
                    ++this.attackStatus;
                    if (this.attackStatus == 5) {
                        this.castSpell(target);
                    } else if (this.attackStatus >= 20) {
                        this.entity.setClap(false);
                        this.resetCooldowns(0, 10);
                    }
                }
                if (this.entity.getSmash()) {
                    ++this.attackStatus;
                    if (this.attackStatus == 10) {
                        int[][] cords;
                        for (int[] cord : cords = new int[][]{{4, 4}, {-4, 4}, {4, -4}, {-4, -4}}) {
                            Vec3 pos = new Vec3(this.entity.m_20185_() + (double)cord[0], this.entity.m_20186_(), this.entity.m_20189_() + (double)cord[1]);
                            if (!this.entity.m_9236_().f_46443_) {
                                ParticleHandler.particleOutburstMap(this.entity.m_9236_(), 50, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), ParticleEvents.CONJURE_ENTITY_MAP, 1.0f);
                            }
                            this.entity.m_9236_().m_5594_(null, target.m_20183_(), (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.PLAYERS, 0.6f, 1.0f);
                            SoulReaperGhost mob = new SoulReaperGhost((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.SOUL_REAPER_GHOST.get()), this.entity.m_9236_());
                            mob.setSoulAmount(0);
                            this.entity.addSummonIds(mob.m_19879_());
                            mob.m_20343_(this.entity.m_20185_() + (double)cord[0], this.entity.m_20186_() + (double)0.1f, this.entity.m_20189_() + (double)cord[1]);
                            if (this.entity.m_269323_() instanceof Player) {
                                mob.m_21828_((Player)this.entity.m_269323_());
                            }
                            this.entity.m_9236_().m_7967_((Entity)mob);
                        }
                    } else if (this.attackStatus >= 20) {
                        this.entity.setSmash(false);
                        this.resetCooldowns(100, 10);
                    }
                }
                if (this.entity.getStartBeam()) {
                    ++this.attackStatus;
                    if (this.attackStatus == 12) {
                        this.entity.setBeaming(true);
                        this.attackStatus = 0;
                        this.entity.setStartBeam(false);
                    }
                }
                if (this.entity.getBeaming()) {
                    ++this.attackStatus;
                    if (this.attackStatus > 30 || target.m_21224_() || distanceToEntity > 140.0) {
                        this.entity.setBeaming(false);
                        this.entity.setStopBeam(true);
                        this.attackStatus = 0;
                    }
                    this.entity.setBeamCords(target.m_146903_(), target.m_20188_(), target.m_146907_());
                    if (this.attackStatus % 5 == 0 && distanceToEntity < 130.0) {
                        target.m_6469_(this.entity.m_9236_().m_269111_().m_269333_((LivingEntity)this.entity), 6.0f);
                        this.entity.m_5634_(2.0f);
                        this.entity.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
                if (this.entity.getStopBeam()) {
                    ++this.attackStatus;
                    if (this.attackStatus == 12) {
                        this.entity.setStopBeam(false);
                        this.resetCooldowns(150, 10);
                    }
                }
                super.m_8037_();
            }
        }

        protected void castSpell(LivingEntity livingEntity) {
            double d = Math.min(livingEntity.m_20186_(), this.entity.m_20186_());
            double e = Math.max(livingEntity.m_20186_(), this.entity.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingEntity.m_20189_() - this.entity.m_20189_()), (double)(livingEntity.m_20185_() - this.entity.m_20185_()));
            if (this.entity.m_20280_((Entity)livingEntity) < 9.0) {
                float g;
                int i;
                for (i = 0; i < 5; ++i) {
                    g = f + (float)i * (float)Math.PI * 0.4f;
                    this.conjureFangs(this.entity.m_20185_() + (double)Mth.m_14089_((float)g) * 1.5, this.entity.m_20189_() + (double)Mth.m_14031_((float)g) * 1.5, d, e, g, 0);
                }
                for (i = 0; i < 8; ++i) {
                    g = f + (float)i * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.conjureFangs(this.entity.m_20185_() + (double)Mth.m_14089_((float)g) * 2.5, this.entity.m_20189_() + (double)Mth.m_14031_((float)g) * 2.5, d, e, g, 3);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    double h = 1.25 * (double)(i + 1);
                    this.conjureFangs(this.entity.m_20185_() + (double)Mth.m_14089_((float)f) * h, this.entity.m_20189_() + (double)Mth.m_14031_((float)f) * h, d, e, f, i);
                }
            }
        }

        private void conjureFangs(double x, double z, double maxY, double y, float yaw, int warmup) {
            BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
            boolean bl = false;
            double d = 0.0;
            do {
                BlockState blockState2;
                VoxelShape voxelShape;
                BlockPos blockPos2 = blockPos.m_7495_();
                BlockState blockState = this.entity.m_9236_().m_8055_(blockPos2);
                if (!blockState.m_60783_((BlockGetter)this.entity.m_9236_(), blockPos2, Direction.UP)) continue;
                if (!this.entity.m_9236_().m_46859_(blockPos) && !(voxelShape = (blockState2 = this.entity.m_9236_().m_8055_(blockPos)).m_60812_((BlockGetter)this.entity.m_9236_(), blockPos)).m_83281_()) {
                    d = voxelShape.m_83297_(Direction.Axis.Y);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
            if (bl) {
                this.entity.m_9236_().m_7967_((Entity)new EvokerFangs(this.entity.m_9236_(), x, (double)blockPos.m_123342_() + d, z, yaw, warmup, (LivingEntity)this.entity));
            }
        }
    }
}

