/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.IAnimatedDeath;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RimeSpectre
extends Remnant
implements GeoEntity,
IAnimatedDeath {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    protected static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(RimeSpectre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(RimeSpectre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> ATTACK_PARTICLE = SynchedEntityData.m_135353_(RimeSpectre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<BlockPos> POS = SynchedEntityData.m_135353_(RimeSpectre.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public RimeSpectre(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new SpectreMoveControl(this);
        this.m_7105_(false);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new RimeSpectreGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> !this.m_21824_() || !(this.m_269323_() instanceof Player)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, entity -> this.m_21824_() && entity instanceof Enemy && !this.m_7307_((Entity)entity)));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268444_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268530_)) {
            return super.m_6469_(source, amount);
        }
        return super.m_6469_(source, amount * 0.1f);
    }

    @Override
    public int getSoulAmount() {
        return 5;
    }

    @Override
    public void initEquip() {
    }

    public static AttributeSupplier.Builder createSpectreAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 10.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_PARTICLE, (Object)false);
        this.f_19804_.m_135372_(POS, (Object)new BlockPos(0, 0, 0));
    }

    private PlayState predicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            state.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else if (this.m_21827_()) {
            state.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
        } else if (this.getShooting()) {
            state.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private PlayState idle(AnimationState<?> state) {
        state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idle)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public boolean getCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public boolean getShooting() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setShooting(boolean bl) {
        this.f_19804_.m_135381_(ATTACKING, (Object)bl);
    }

    public boolean getShootingParticle() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK_PARTICLE);
    }

    public void setShootingParticle(boolean bl) {
        this.f_19804_.m_135381_(ATTACK_PARTICLE, (Object)bl);
    }

    public BlockPos getShootPos() {
        return (BlockPos)this.f_19804_.m_135370_(POS);
    }

    public void setShootPos(BlockPos pos) {
        this.f_19804_.m_135381_(POS, (Object)pos);
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(6.0))) {
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || this.m_21830_(target = (LivingEntity)entity) || this.m_7307_((Entity)target)) continue;
            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZING.get(), 20, 0));
        }
        if (this.m_21023_((MobEffect)EffectRegistry.FREEZING.get())) {
            this.m_21195_((MobEffect)EffectRegistry.FREEZING.get());
        }
    }

    public void m_6478_(MoverType movementType, Vec3 movement) {
        super.m_6478_(movementType, movement);
        this.m_20101_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        if (this.getShootingParticle()) {
            BlockPos pos = this.getShootPos();
            double distanceToEntity = this.m_20275_(pos.m_123341_(), (float)pos.m_123342_() + 0.5f, pos.m_123343_());
            for (int i = 0; i < 20; ++i) {
                double e = (double)pos.m_123341_() - this.m_20185_();
                double f = (double)((float)pos.m_123342_() + 0.5f) - this.m_20227_(1.0);
                double g = (double)pos.m_123343_() - this.m_20189_();
                double h = Math.sqrt(Math.sqrt(distanceToEntity)) * 0.5;
                if (!this.m_9236_().f_46443_) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20188_(), this.m_20189_(), (e + this.m_217043_().m_188583_() * h) / 4.0, (f + this.m_217043_().m_188583_()) / 4.0, (g + this.m_217043_().m_188583_() * h) / 4.0);
            }
        }
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            if (!this.m_9236_().f_46443_) {
                ParticleHandler.particleSphere(this.m_9236_(), 600, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), ParticleEvents.ICE_PARTICLE, 1.0f);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11983_, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11983_, SoundSource.HOSTILE, 1.0f, 0.5f);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public int getTicksUntilDeath() {
        return 15;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12557_;
    }

    @Override
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12554_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12557_;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public boolean m_21222_() {
        return false;
    }

    class SpectreMoveControl
    extends MoveControl {
        public SpectreMoveControl(RimeSpectre owner) {
            super((Mob)owner);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3d = new Vec3(this.f_24975_ - RimeSpectre.this.m_20185_(), this.f_24976_ - RimeSpectre.this.m_20186_(), this.f_24977_ - RimeSpectre.this.m_20189_());
                double d = vec3d.m_82553_();
                if (d < RimeSpectre.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    RimeSpectre.this.m_20256_(RimeSpectre.this.m_20184_().m_82490_(0.5));
                } else {
                    RimeSpectre.this.m_20256_(RimeSpectre.this.m_20184_().m_82549_(vec3d.m_82490_(this.f_24978_ * 0.05 / d)));
                    if (RimeSpectre.this.m_5448_() == null) {
                        Vec3 vec3d2 = RimeSpectre.this.m_20184_();
                        RimeSpectre.this.m_146922_(-((float)Mth.m_14136_((double)vec3d2.f_82479_, (double)vec3d2.f_82481_)) * 57.295776f);
                    } else {
                        double e = RimeSpectre.this.m_5448_().m_20185_() - RimeSpectre.this.m_20185_();
                        double f = RimeSpectre.this.m_5448_().m_20189_() - RimeSpectre.this.m_20189_();
                        RimeSpectre.this.m_146922_(-((float)Mth.m_14136_((double)e, (double)f)) * 57.295776f);
                    }
                    RimeSpectre.this.f_20883_ = RimeSpectre.this.m_146908_();
                }
            }
        }
    }

    static class RimeSpectreGoal
    extends Goal {
        private final RimeSpectre mob;
        private int attackStatus;
        private int cooldown;

        public RimeSpectreGoal(RimeSpectre mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            return !this.mob.m_21827_() && target != null && target.m_6084_() && this.mob.m_6779_(target) && this.mob.m_217043_().m_188503_(7) == 0;
        }

        public boolean m_8045_() {
            return !this.mob.m_21827_() && this.mob.getCharging() && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingEntity = this.mob.m_5448_();
            if (livingEntity == null) {
                return;
            }
            Vec3 vec3d = livingEntity.m_146892_();
            this.mob.m_21566_().m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
            this.mob.setCharging(true);
        }

        public void m_8041_() {
            this.mob.setCharging(false);
            this.mob.setShooting(false);
            this.mob.setShootingParticle(false);
        }

        public boolean m_183429_() {
            return true;
        }

        private void moveRandomSpot(Vec3 vec3d) {
            this.mob.m_21566_().m_6849_(vec3d.f_82479_ + (double)this.mob.m_217043_().m_188503_(8) - 4.0, vec3d.f_82480_ + (double)this.mob.m_217043_().m_188503_(3), vec3d.f_82481_ + (double)this.mob.m_217043_().m_188503_(8) - 4.0, 1.0);
        }

        public void m_8037_() {
            this.cooldown = Math.max(this.cooldown - 1, 0);
            LivingEntity target = this.mob.m_5448_();
            if (target != null && target.m_20183_() != null) {
                Vec3 vec3d = target.m_146892_();
                if (this.cooldown > 0) {
                    this.moveRandomSpot(vec3d);
                }
                if (this.cooldown <= 0 && !this.mob.m_5830_()) {
                    this.mob.setShooting(true);
                    this.frostBeam(target);
                }
            }
        }

        private void frostBeam(LivingEntity target) {
            ++this.attackStatus;
            this.mob.setShootPos(target.m_20183_());
            this.mob.m_21563_().m_148051_((Entity)target);
            this.mob.m_21573_().m_26573_();
            if (this.attackStatus >= 15) {
                this.mob.setShootingParticle(true);
                if (this.attackStatus % 2 == 0) {
                    AABB box = new AABB(target.m_20183_(), this.mob.m_20183_().m_7918_(0, 1, 0)).m_82400_(1.0);
                    for (Entity entity : this.mob.m_9236_().m_45933_((Entity)this.mob, box)) {
                        LivingEntity living;
                        if (!(entity instanceof LivingEntity) || this.mob.m_21830_(living = (LivingEntity)entity) || this.mob.m_7307_((Entity)living)) continue;
                        living.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZING.get(), 40, 2));
                        living.m_6469_(this.mob.m_9236_().m_269111_().m_269333_((LivingEntity)this.mob), 2.0f);
                    }
                }
            }
            if (this.attackStatus >= 40) {
                this.attackStatus = 0;
                this.cooldown = 40;
                this.mob.setShootingParticle(false);
                this.mob.setShooting(false);
            }
        }
    }
}

