/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.FreyrSwordGoal;
import net.soulsweaponry.entitydata.FreyrSwordSummonData;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FreyrSwordEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final ItemStack stack;
    public static final BlockPos NULLISH_POS = new BlockPos(0, 0, 0);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(FreyrSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<BlockPos> STATIONARY = SynchedEntityData.m_135353_(FreyrSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> IS_STATIONARY = SynchedEntityData.m_135353_(FreyrSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final String STACK_NBT = "enchants_list";

    public FreyrSwordEntity(EntityType<? extends FreyrSwordEntity> entityType, Level world) {
        super(entityType, world);
        this.stack = new ItemStack((ItemLike)WeaponRegistry.FREYR_SWORD.get());
    }

    public FreyrSwordEntity(Level world, Player owner, ItemStack stack) {
        super((EntityType)EntityRegistry.FREYR_SWORD_ENTITY_TYPE.get(), world);
        this.stack = stack.m_41777_();
        this.m_7105_(true);
        this.m_21828_(owner);
    }

    public PlayState attack(AnimationState<?> state) {
        if (this.getAnimationAttacking()) {
            state.getController().setAnimation(RawAnimation.begin().then("attack_east", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        state.getController().stop();
        return PlayState.STOP;
    }

    private PlayState idle(AnimationState<?> state) {
        if (!this.getAnimationAttacking()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController attackController = new AnimationController((GeoAnimatable)this, "attackController", 0, this::attack);
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 0, this::idle);
        controllers.add(new AnimationController[]{attackController});
        controllers.add(new AnimationController[]{idleController});
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FreyrSwordGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Slime.class, true));
        super.m_8099_();
    }

    public boolean m_7307_(Entity other) {
        OwnableEntity tameableOther;
        if (!ConfigConstructor.sword_of_freyr_friendly_fire && other instanceof Player) {
            return true;
        }
        if (other instanceof OwnableEntity && (tameableOther = (OwnableEntity)other).m_269323_() != null && this.m_269323_() != null && tameableOther.m_269323_().equals((Object)this.m_269323_())) {
            return true;
        }
        return super.m_7307_(other);
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.m_269323_() != null) {
            if (!this.isBlockPosNullish(this.getStationaryPos())) {
                if (this.m_5448_() == null || this.m_20238_(this.stationaryAsVec3d()) > this.getFollowRange()) {
                    this.m_20248_(this.getStationaryPos().m_123341_(), this.getStationaryPos().m_123342_(), this.getStationaryPos().m_123343_());
                    this.setAnimationAttacking(false);
                }
            } else if (this.m_5448_() == null || this.m_20280_((Entity)this.m_269323_()) > this.getFollowRange()) {
                Vec3 vecOwner = this.m_269323_().m_20154_();
                double xAdd = 0.0;
                if (this.m_269323_().m_146909_() < -50.0f || this.m_269323_().m_146909_() > 50.0f) {
                    xAdd = vecOwner.m_7096_() > 0.0 ? -1.0 : 1.0;
                }
                Vec3 vecEdited = vecOwner.m_82490_(-1.5).m_82549_(this.m_269323_().m_20182_()).m_82520_(xAdd, 0.0, 0.0);
                this.m_19890_(vecEdited.m_7096_(), this.m_269323_().m_20186_(), vecEdited.m_7094_(), this.m_269323_().m_146908_() / 2.0f, this.m_269323_().m_146909_());
                this.setAnimationAttacking(false);
            }
        }
    }

    public EntityGetter m_9236_() {
        return super.m_9236_();
    }

    public int m_20146_() {
        return 300;
    }

    @Nullable
    public LivingEntity m_269323_() {
        try {
            Player owner;
            UUID uUID = this.m_21805_();
            Player player = owner = uUID == null ? null : this.m_9236_().m_46003_(uUID);
            if (owner instanceof Player) {
                Player player2 = owner;
                UUID swordUuid = FreyrSwordSummonData.getSummonUuid((LivingEntity)player2);
                if (swordUuid != null && swordUuid.equals(this.m_20148_())) {
                    return owner;
                }
                return null;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_269323_() == null || this.m_269323_() != null && this.m_269323_().equals((Object)player)) {
            if (!this.insertStack(player)) {
                this.m_20343_(player.m_20185_(), player.m_20188_(), player.m_20189_());
                this.dropStack();
            }
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean insertStack(Player player) {
        int slot = player.m_150109_().f_35977_;
        if (!player.m_150109_().m_36056_().m_41619_()) {
            slot = -1;
        }
        return player.m_150109_().m_36040_(slot, this.asItemStack());
    }

    public void dropStack() {
        ItemEntity entity = this.m_19983_(this.stack);
        if (entity != null) {
            entity.m_32064_();
        }
    }

    public void m_6667_(DamageSource damageSource) {
        if (!this.m_9236_().f_46443_ && this.m_20183_() != null) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.stack.m_220157_(10, this.m_217043_(), null);
            if (this.stack.m_41776_() - this.stack.m_41773_() > 0) {
                LivingEntity livingEntity;
                if (this.m_269323_() != null && (livingEntity = this.m_269323_()) instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (!this.insertStack(player)) {
                        this.m_20343_(player.m_20185_(), player.m_20188_(), player.m_20189_());
                        this.dropStack();
                    }
                } else {
                    this.dropStack();
                }
            }
        }
        super.m_6667_(damageSource);
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean isBlockPosNullish(BlockPos pos) {
        return pos.m_123341_() == 0 && pos.m_123342_() == 0 && pos.m_123343_() == 0;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19797_ % 4 == 0) {
            double random = this.m_217043_().m_188500_();
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_175827_, false, this.m_20185_() + random / 4.0 - random / 8.0, this.m_20188_() - random * 6.0 + random * 6.0 / 2.0, this.m_20189_() + random / 4.0 - random / 8.0, random / 16.0 - random / 32.0, random - random / 2.0, random / 16.0 - random / 32.0);
        }
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    public int getNoOwnerAge() {
        return 60;
    }

    public static AttributeSupplier.Builder createEntityAttributes() {
        return PathfinderMob.m_21183_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, (double)ConfigConstructor.sword_of_freyr_damage);
    }

    public double getFollowRange() {
        return this.m_21133_(Attributes.f_22277_);
    }

    public ItemStack asItemStack() {
        return this.stack;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setAnimationAttacking(boolean bl) {
        this.f_19804_.m_135381_(ATTACKING, (Object)bl);
    }

    private boolean getAnimationAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public BlockPos getStationaryPos() {
        return (BlockPos)this.f_19804_.m_135370_(STATIONARY);
    }

    public void setStationaryPos(BlockPos pos) {
        if (((Boolean)this.f_19804_.m_135370_(IS_STATIONARY)).booleanValue()) {
            this.f_19804_.m_135381_(STATIONARY, (Object)NULLISH_POS);
            this.f_19804_.m_135381_(IS_STATIONARY, (Object)false);
        } else {
            this.f_19804_.m_135381_(STATIONARY, (Object)pos);
            this.f_19804_.m_135381_(IS_STATIONARY, (Object)true);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && this.m_269323_() != null && source.m_7639_().equals((Object)this.m_269323_())) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public Vec3 stationaryAsVec3d() {
        return new Vec3((double)this.getStationaryPos().m_123341_(), (double)this.getStationaryPos().m_123342_(), (double)this.getStationaryPos().m_123343_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(STATIONARY, (Object)NULLISH_POS);
        this.f_19804_.m_135372_(IS_STATIONARY, (Object)Boolean.FALSE);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12600_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12601_;
    }

    public AgeableMob m_142606_(ServerLevel var1, AgeableMob var2) {
        return null;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ItemStack itemStack = this.asItemStack();
        if (itemStack.m_41783_() != null) {
            nbt.m_128365_(STACK_NBT, (Tag)itemStack.m_41783_());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_(STACK_NBT)) {
            this.stack.m_41751_((CompoundTag)nbt.m_128423_(STACK_NBT));
        }
    }
}

