/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.soulsweaponry.entity.mobs.ReturningKnight;
import net.soulsweaponry.registry.ArmorRegistry;

public class DarkSorcerer
extends Monster {
    private static final EntityDataAccessor<Boolean> BEAMING = SynchedEntityData.m_135353_(DarkSorcerer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<BlockPos> BEAM_CORDS = SynchedEntityData.m_135353_(DarkSorcerer.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public DarkSorcerer(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.initEquip();
    }

    public static AttributeSupplier.Builder createSorcererAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.3000000003).m_22268_(Attributes.f_22281_, 2.0);
    }

    public boolean m_6914_(LevelReader view) {
        BlockPos blockUnderEntity = new BlockPos(this.m_146903_(), this.m_146904_() - 1, this.m_146907_());
        BlockState state = this.m_9236_().m_8055_(this.m_20183_());
        return view.m_45784_((Entity)this) && !this.m_9236_().m_46855_(this.m_20191_()) && state.m_60734_().m_48673_(state) && this.m_9236_().m_8055_(blockUnderEntity).m_60713_(Blocks.f_152559_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BEAMING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(BEAM_CORDS, (Object)new BlockPos(0, 0, 0));
    }

    public void setBeaming(boolean bl) {
        this.f_19804_.m_135381_(BEAMING, (Object)bl);
    }

    public boolean getBeaming() {
        return (Boolean)this.f_19804_.m_135370_(BEAMING);
    }

    public void setBeamCords(double x, double y, double z) {
        this.f_19804_.m_135381_(BEAM_CORDS, (Object)BlockPos.m_274561_((double)x, (double)y, (double)z));
    }

    public BlockPos getBeamCords() {
        return (BlockPos)this.f_19804_.m_135370_(BEAM_CORDS);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BeamTargetGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, ReturningKnight.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static boolean canSpawn(EntityType<DarkSorcerer> darkSorcererEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return serverWorldAccess.m_46791_() != Difficulty.PEACEFUL;
    }

    public void m_8107_() {
        if (this.getBeaming()) {
            double e = (double)this.getBeamCords().m_123341_() - this.m_20185_();
            double f = (double)this.getBeamCords().m_123342_() - this.m_20188_();
            double g = (double)this.getBeamCords().m_123343_() - this.m_20189_();
            double h = Math.sqrt(e * e + f * f + g * g);
            e /= h;
            f /= h;
            g /= h;
            double length = this.f_19796_.m_188500_();
            for (int i = 0; i < 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_() + e * (length += 0.5 + this.f_19796_.m_188500_()), this.m_20188_() + f * length, this.m_20189_() + g * length, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175827_, this.m_20185_() + e * length, this.m_20188_() + f * length, this.m_20189_() + g * length, 0.0, 0.0, 0.0);
            }
            double dd = this.f_19796_.m_188583_() * 0.05;
            double ee = this.f_19796_.m_188583_() * 0.05;
            double newX = this.f_19796_.m_188500_() - 0.5 + this.f_19796_.m_188583_() * 0.15 + dd;
            double newZ = this.f_19796_.m_188500_() - 0.5 + this.f_19796_.m_188583_() * 0.15 + ee;
            double newY = this.f_19796_.m_188500_() - 0.5 + this.f_19796_.m_188500_() * 0.5;
            float body = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float cosBody = Mth.m_14089_((float)body);
            float sinBody = Mth.m_14031_((float)body);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)cosBody * 0.5, this.m_20186_() + 1.8, this.m_20189_() + (double)sinBody * 0.5, newX, newY, newZ);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)cosBody * 0.5, this.m_20186_() + 1.8, this.m_20189_() - (double)sinBody * 0.5, newX, newY, newZ);
        }
        super.m_8107_();
    }

    public void initEquip() {
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ArmorRegistry.SOUL_ROBES_HELMET.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ArmorRegistry.SOUL_ROBES_CHESTPLATE.get()));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ArmorRegistry.SOUL_ROBES_LEGGINGS.get()));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ArmorRegistry.SOUL_ROBES_BOOTS.get()));
    }

    public boolean m_21222_() {
        return true;
    }

    static class BeamTargetGoal
    extends Goal {
        private final DarkSorcerer user;
        private int attackTicks;
        private Path path;

        public BeamTargetGoal(DarkSorcerer user) {
            this.user = user;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.user.m_5448_();
            if (target != null) {
                this.path = this.user.m_21573_().m_6570_((Entity)target, 0);
            }
            return target != null && target.m_6084_() && this.user.m_6779_(target) && this.path != null;
        }

        public void m_8041_() {
            this.user.setBeaming(false);
            super.m_8041_();
        }

        public void m_8037_() {
            --this.attackTicks;
            LivingEntity target = this.user.m_5448_();
            double distanceToEntity = this.user.m_20280_((Entity)target);
            if (target != null) {
                this.user.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
                if (target instanceof ReturningKnight) {
                    if (distanceToEntity < 150.0) {
                        this.user.setBeaming(true);
                        this.user.setBeamCords(target.m_146903_(), target.m_20188_(), target.m_146907_());
                        if (target.m_21223_() < target.m_21233_()) {
                            target.m_21153_(target.m_21223_() + 0.5f + (float)((ReturningKnight)target).getAttackingPlayers().size() / 2.0f);
                        }
                    } else {
                        this.user.setBeaming(false);
                    }
                } else if (distanceToEntity < 150.0) {
                    this.user.setBeaming(true);
                    this.user.setBeamCords(target.m_146903_(), target.m_20188_(), target.m_146907_());
                    if (this.attackTicks < 0) {
                        target.m_6469_(this.user.m_9236_().m_269111_().m_269333_((LivingEntity)this.user), 2.0f);
                        this.attackTicks = 10;
                    }
                } else {
                    this.user.setBeaming(false);
                    this.attackTicks = 10;
                }
                if (distanceToEntity < 100.0) {
                    this.user.m_21573_().m_26573_();
                }
                if (this.path != null && distanceToEntity > 100.0) {
                    this.user.m_21573_().m_26536_(this.path, 1.0);
                }
                super.m_8037_();
            }
        }
    }
}

