/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.entity.util.RandomSummonPos;
import net.soulsweaponry.items.HolyMoonlightGreatsword;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import org.jetbrains.annotations.Nullable;

public class MoonknightGoal
extends Goal {
    private final Moonknight boss;
    private int attackStatus;
    private int attackCooldown;
    private int specialCooldown;
    private int targetNotVisibleTicks;
    private BlockPos targetPos;
    private float yaw;
    private MoonlightProjectile.RotationState projectileRotation = MoonlightProjectile.RotationState.SWIPE_FROM_RIGHT;
    private float bonusBeamHeight = 0.0f;
    private double height = 0.0;

    public MoonknightGoal(Moonknight boss) {
        this.boss = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.boss.m_5448_();
        return target != null && target.m_6084_() && this.boss.m_6779_(target);
    }

    public float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.fallen_icon_damage_modifier;
    }

    private void resetAttack(float attackCDModifier, boolean wasSpecial, float specialCDModifier) {
        if (!this.boss.isPhaseTwo()) {
            this.checkAttackPhaseOne(Moonknight.MoonknightPhaseOne.IDLE, this.boss.m_5448_());
        } else {
            this.checkAttackPhaseTwo(Moonknight.MoonknightPhaseTwo.IDLE, this.boss.m_5448_());
        }
        this.attackStatus = 0;
        this.attackCooldown = (int)Math.floor((float)(this.boss.isPhaseTwo() ? ConfigConstructor.fallen_icon_attack_cooldown_ticks_phase_2 : ConfigConstructor.fallen_icon_attack_cooldown_ticks_phase_1) * attackCDModifier) - this.boss.getReducedCooldownAttackers() * 2;
        if (wasSpecial) {
            this.specialCooldown = (int)Math.floor((float)ConfigConstructor.fallen_icon_special_cooldown_ticks * specialCDModifier) - this.boss.getReducedCooldownAttackers() * 2;
        }
    }

    private void reset() {
        this.attackCooldown = 0;
        this.attackStatus = 0;
        this.specialCooldown = 0;
        this.bonusBeamHeight = 0.0f;
        this.projectileRotation = MoonlightProjectile.RotationState.SWIPE_FROM_RIGHT;
        this.boss.setCanBeam(false);
        this.boss.setIncreasingBeamHeight(false);
        this.boss.setBeamHeight(0.0f);
    }

    public void m_8041_() {
        super.m_8041_();
        this.reset();
        this.boss.m_21561_(false);
        if (this.boss.isPhaseTwo()) {
            this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
        } else {
            this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
        }
    }

    private Moonknight.MoonknightPhaseOne randomAttackPhaseOne() {
        int rand = this.boss.m_217043_().m_188503_(Moonknight.MoonknightPhaseOne.values().length);
        Moonknight.MoonknightPhaseOne attack = Moonknight.MoonknightPhaseOne.values()[rand];
        if (attack.equals((Object)Moonknight.MoonknightPhaseOne.IDLE)) {
            return this.randomAttackPhaseOne();
        }
        return attack;
    }

    private Moonknight.MoonknightPhaseTwo randomAttackPhaseTwo() {
        int rand = this.boss.m_217043_().m_188503_(Moonknight.MoonknightPhaseTwo.values().length);
        Moonknight.MoonknightPhaseTwo attack = Moonknight.MoonknightPhaseTwo.values()[rand];
        if (attack.equals((Object)Moonknight.MoonknightPhaseTwo.IDLE)) {
            return this.randomAttackPhaseTwo();
        }
        return attack;
    }

    private void checkAttackPhaseOne(@Nullable Moonknight.MoonknightPhaseOne specificPhaseOne, LivingEntity target) {
        if (target == null || specificPhaseOne != null && specificPhaseOne.equals((Object)Moonknight.MoonknightPhaseOne.IDLE)) {
            this.boss.setPhaseOneAttack(specificPhaseOne);
            return;
        }
        Moonknight.MoonknightPhaseOne attack = Objects.requireNonNullElseGet(specificPhaseOne, this::randomAttackPhaseOne);
        double distance = this.boss.m_20280_((Entity)target);
        switch (attack) {
            case BLINDING_LIGHT: {
                if (distance < 30.0) {
                    this.boss.setPhaseOneAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                break;
            }
            case MACE_OF_SPADES: {
                if (distance < 50.0 && target.m_20183_() != null) {
                    this.boss.setPhaseOneAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                break;
            }
            case OBLITERATE: {
                if (distance < 75.0 && target.m_20183_() != null) {
                    this.boss.setPhaseOneAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                break;
            }
            case RUPTURE: 
            case SUMMON: {
                if (this.specialCooldown < 0) {
                    this.boss.setPhaseOneAttack(attack);
                    break;
                }
                if (this.specialCooldown <= 20) break;
                this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                break;
            }
            default: {
                this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
            }
        }
    }

    private void checkAttackPhaseTwo(@Nullable Moonknight.MoonknightPhaseTwo specificPhaseTwo, LivingEntity target) {
        if (target == null || specificPhaseTwo != null && specificPhaseTwo.equals((Object)Moonknight.MoonknightPhaseTwo.IDLE)) {
            this.boss.setPhaseTwoAttack(specificPhaseTwo);
            return;
        }
        Moonknight.MoonknightPhaseTwo attack = Objects.requireNonNullElseGet(specificPhaseTwo, this::randomAttackPhaseTwo);
        double distance = this.boss.m_20280_((Entity)target);
        switch (attack) {
            case BLINDING_LIGHT: {
                if (distance < 32.0) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                break;
            }
            case CORE_BEAM: {
                if (this.specialCooldown < 0 && distance < 180.0) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.specialCooldown <= 10 && this.attackCooldown >= -30) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                break;
            }
            case MOONFALL: {
                if (distance < 80.0 && target.m_20183_() != null) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                break;
            }
            case MOONVEIL: {
                if (distance < 36.0 && this.specialCooldown < 0) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.specialCooldown <= 10 && this.attackCooldown >= -10) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                break;
            }
            case SWORD_OF_LIGHT: {
                if (distance < 300.0) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.SWORD_OF_LIGHT);
                break;
            }
            case THRUST: {
                if (distance < 128.0) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                break;
            }
            default: {
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
            }
        }
    }

    public void m_8037_() {
        --this.attackCooldown;
        --this.specialCooldown;
        LivingEntity target = this.boss.m_5448_();
        if (this.boss.isInitiatingPhaseTwo()) {
            this.reset();
        }
        if (!(target == null || this.boss.m_21224_() || this.boss.getSpawning() || this.boss.isInitiatingPhaseTwo() || this.boss.getUnbreakable())) {
            this.boss.m_21561_(true);
            this.boss.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
            boolean entityInSight = this.boss.m_21574_().m_148306_((Entity)target);
            this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
            if (this.attackCooldown > 0) {
                if (!this.boss.isPhaseTwo()) {
                    this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                } else {
                    this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                }
            } else if (this.attackCooldown < 0 && this.attackCooldown % 5 == 0) {
                if (!this.boss.isPhaseTwo() && this.boss.getPhaseOneAttack().equals((Object)Moonknight.MoonknightPhaseOne.IDLE)) {
                    this.checkAttackPhaseOne(null, target);
                } else if (this.boss.getPhaseTwoAttack().equals((Object)Moonknight.MoonknightPhaseTwo.IDLE)) {
                    this.checkAttackPhaseTwo(null, target);
                }
            }
            if (!this.boss.isPhaseTwo()) {
                switch (this.boss.getPhaseOneAttack()) {
                    case BLINDING_LIGHT: {
                        this.blindingLightLogic();
                        break;
                    }
                    case MACE_OF_SPADES: {
                        this.maceOfSpadesLogic(target);
                        break;
                    }
                    case OBLITERATE: {
                        this.obliterateLogic(target, 13, 3, 28, 50.0f, (SoundEvent)SoundRegistry.NIGHTFALL_BONK_EVENT.get(), false);
                        break;
                    }
                    case RUPTURE: {
                        this.ruptureLogic();
                        break;
                    }
                    case SUMMON: {
                        this.summonLogic(target);
                        break;
                    }
                    default: {
                        this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                        break;
                    }
                }
            } else {
                switch (this.boss.getPhaseTwoAttack()) {
                    case BLINDING_LIGHT: {
                        this.blindingLightLogic();
                        break;
                    }
                    case CORE_BEAM: {
                        this.coreBeam(target);
                        break;
                    }
                    case MOONFALL: {
                        this.moonfallLogic(target);
                        break;
                    }
                    case MOONVEIL: {
                        this.moonveilLogic();
                        break;
                    }
                    case SWORD_OF_LIGHT: {
                        this.swordOfLight(target);
                        break;
                    }
                    case THRUST: {
                        this.thrustLogic(target);
                        break;
                    }
                    default: {
                        this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                    }
                }
            }
            if (this.targetNotVisibleTicks < 5) {
                this.boss.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
            }
        }
        super.m_8037_();
    }

    private void coreBeam(LivingEntity target) {
        ++this.attackStatus;
        if (this.attackStatus == 1) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_12001_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.attackStatus < 20 && target.m_20183_() != null) {
            this.targetPos = target.m_20183_();
        }
        if (this.targetPos != null) {
            this.boss.m_21563_().m_24946_((double)this.targetPos.m_123341_(), (double)((float)this.targetPos.m_123342_() + this.bonusBeamHeight), (double)this.targetPos.m_123343_());
            this.boss.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)((float)this.targetPos.m_123342_() + this.bonusBeamHeight), (double)this.targetPos.m_123343_(), 0.0);
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
            if (this.attackStatus >= 21 && this.attackStatus <= 47) {
                if (this.attackStatus == 21) {
                    this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), (SoundEvent)SoundRegistry.KNIGHT_CORE_BEAM_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                this.boss.setCanBeam(true);
                this.boss.setBeamLocation(this.targetPos);
                if (this.attackStatus % 2 == 0) {
                    this.boss.m_9236_().m_254877_((Entity)this.boss, CustomDamageSource.create(this.boss.m_9236_(), CustomDamageSource.BEAM, (Entity)this.boss), null, (double)this.targetPos.m_123341_(), (double)((float)this.targetPos.m_123342_() + this.bonusBeamHeight), (double)this.targetPos.m_123343_(), 2.0f, true, this.boss.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
                    for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(this.targetPos, this.boss.m_20183_().m_7918_(0, 4, 0)))) {
                        if (!(entity instanceof LivingEntity)) continue;
                        entity.m_6469_(CustomDamageSource.create(this.boss.m_9236_(), CustomDamageSource.BEAM, (Entity)this.boss), this.getModifiedDamage(20.0f));
                        entity.m_20254_(4);
                    }
                }
                if (this.attackStatus >= 26) {
                    this.bonusBeamHeight += 0.65f;
                    this.boss.setIncreasingBeamHeight(true);
                }
            }
            if (this.attackStatus > 40) {
                this.targetPos = this.targetPos.m_7918_(0, Mth.m_14143_((float)(-this.bonusBeamHeight)), 0);
                this.boss.setCanBeam(false);
                this.boss.setIncreasingBeamHeight(false);
            }
        }
        if (this.attackStatus >= 77) {
            this.boss.m_21573_().m_26573_();
            this.bonusBeamHeight = 0.0f;
            this.boss.setBeamHeight(0.0f);
            this.resetAttack(1.0f, true, 1.0f);
        }
    }

    private void swordOfLight(LivingEntity target) {
        ++this.attackStatus;
        double distance = this.boss.m_20280_((Entity)target);
        if (target.m_20183_() != null) {
            if (distance < 65.0) {
                this.targetPos = target.m_20183_();
            } else {
                Vec3 direction = new Vec3(target.m_20185_() - (double)this.boss.m_146903_(), 0.0, target.m_20189_() - (double)this.boss.m_146907_()).m_82490_(0.5);
                Vec3 spot = new Vec3(this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_()).m_82549_(direction);
                this.targetPos = BlockPos.m_274446_((Position)spot);
            }
        }
        if (this.targetPos != null && target.m_20182_() != null) {
            MoonlightProjectile projectile;
            double x = target.m_20185_() - this.boss.m_20185_();
            double y = target.m_20188_() - this.boss.m_20227_(1.0);
            double z = target.m_20189_() - this.boss.m_20189_();
            this.boss.m_21563_().m_24946_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_());
            this.boss.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 0.0);
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
            if (this.attackStatus == 8 || this.attackStatus == 15 || this.attackStatus == 20 || this.attackStatus == 25) {
                this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, 1.0f, 0.75f);
                for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(this.targetPos).m_82400_(3.0))) {
                    if (!(entity instanceof LivingEntity)) continue;
                    entity.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(25.0f));
                    ((LivingEntity)entity).m_147240_(2.0, -(entity.m_20185_() - this.boss.m_20185_()), -(entity.m_20189_() - this.boss.m_20189_()));
                }
                this.boss.m_9236_().m_5594_(null, this.targetPos, (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                projectile = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE.get()), this.boss.m_9236_(), (LivingEntity)this.boss);
                projectile.setAgeAndPoints(30, 150, 4);
                projectile.m_36781_(this.getModifiedDamage(25.0f));
                projectile.m_20343_(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
                projectile.m_6686_(x, y, z, 1.5f, 1.0f);
                projectile.setRotateState(this.projectileRotation);
                this.projectileRotation = Objects.requireNonNull(this.projectileRotation) == MoonlightProjectile.RotationState.SWIPE_FROM_RIGHT ? MoonlightProjectile.RotationState.SWIPE_FROM_LEFT : MoonlightProjectile.RotationState.NORMAL;
                this.boss.m_9236_().m_7967_((Entity)projectile);
            }
            if (this.attackStatus == 27) {
                this.boss.m_9236_().m_5594_(null, this.targetPos, (SoundEvent)SoundRegistry.KNIGHT_SWORD_SMASH_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.attackStatus == 31) {
                this.smashGround(30.0f, (SoundEvent)SoundRegistry.KNIGHT_SWORD_SMASH_EVENT.get(), true);
                this.boss.m_9236_().m_5594_(null, this.targetPos, (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), SoundSource.HOSTILE, 1.0f, 0.75f);
                projectile = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.VERTICAL_MOONLIGHT_ENTITY_TYPE.get()), this.boss.m_9236_(), (LivingEntity)this.boss);
                projectile.m_20343_(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
                projectile.m_6686_(x, y, z, 1.5f, 1.0f);
                projectile.m_36781_(this.getModifiedDamage(40.0f));
                projectile.setHugeExplosion(true);
                projectile.setAgeAndPoints(30, 75, 10);
                this.boss.m_9236_().m_7967_((Entity)projectile);
            }
        }
        if (this.attackStatus >= 37) {
            this.boss.m_21573_().m_26573_();
            this.projectileRotation = MoonlightProjectile.RotationState.SWIPE_FROM_RIGHT;
            this.resetAttack(1.0f, false, 1.0f);
        }
    }

    private void thrustLogic(LivingEntity target) {
        ++this.attackStatus;
        if (this.attackStatus == 1) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), (SoundEvent)SoundRegistry.KNIGHT_CHARGE_SWORD_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.attackStatus < 1) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_12001_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.attackStatus < 13 && target.m_20183_() != null) {
            this.targetPos = target.m_20183_();
            this.height = target.m_20188_();
        } else if (this.targetPos != null) {
            this.boss.m_21563_().m_24946_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_());
            this.boss.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 0.0);
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
            if (this.attackStatus == 15) {
                this.boss.m_9236_().m_5594_(null, this.targetPos, (SoundEvent)SoundRegistry.KNIGHT_THRUST_SWORD_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.attackStatus == 17 && this.boss.m_20280_((Entity)target) < 128.0) {
                for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(this.targetPos).m_82400_(1.0))) {
                    if (!(entity instanceof LivingEntity)) continue;
                    entity.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(50.0f));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19599_, 200, 1));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.DISABLE_HEAL.get(), 100, 0));
                }
                if (!this.boss.m_9236_().f_46443_) {
                    ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 250, this.targetPos.m_123341_(), this.height == 0.0 ? (double)this.targetPos.m_123342_() : this.height, this.targetPos.m_123343_(), ParticleEvents.SOUL_FLAME_SMALL_OUTBURST_MAP, 1.0f);
                }
            }
        }
        if (this.attackStatus >= 23) {
            this.boss.m_21573_().m_26573_();
            this.resetAttack(0.75f, false, 1.0f);
        }
    }

    private void moonfallLogic(LivingEntity target) {
        this.obliterateLogic(target, 25, 15, 43, 65.0f, (SoundEvent)SoundRegistry.KNIGHT_SWORD_SMASH_EVENT.get(), true);
        if (this.attackStatus == 18) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), (SoundEvent)SoundRegistry.KNIGHT_SWORD_SMASH_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.attackStatus == 1) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), (SoundEvent)SoundRegistry.KNIGHT_CHARGE_SWORD_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.attackStatus == 26) {
            float yaw = (this.yaw == 0.0f ? this.boss.m_6080_() : this.yaw) + 90.0f;
            ((HolyMoonlightGreatsword)WeaponRegistry.HOLY_MOONLIGHT_GREATSWORD.get()).castSpell((LivingEntity)this.boss, this.boss.m_9236_(), ((HolyMoonlightGreatsword)WeaponRegistry.HOLY_MOONLIGHT_GREATSWORD.get()).m_7968_(), this.targetPos.m_252807_(), 14, this.getModifiedDamage(30.0f), 1.0f, yaw, 1.5f, 3.5f);
        }
    }

    private void moonveilLogic() {
        ++this.attackStatus;
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 5));
        if (this.attackStatus == 29 || this.attackStatus == 42) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_(3.0))) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                double x = livingEntity.m_20185_() - this.boss.m_20185_();
                double z = livingEntity.m_20189_() - this.boss.m_20189_();
                livingEntity.m_147240_(10.0, -x, -z);
                livingEntity.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(50.0f));
            }
            if (!this.boss.m_9236_().f_46443_) {
                ParticleHandler.particleSphereList(this.boss.m_9236_(), 1000, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 1.0f, new ParticleOptions[]{ParticleTypes.f_123745_, ParticleTypes.f_123755_});
            }
        }
        if (this.attackStatus >= 55) {
            this.resetAttack(1.2f, true, 1.0f);
        }
    }

    private void smashGround(float damage, SoundEvent sound, boolean isSoundDelayed) {
        for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(this.targetPos).m_82400_(3.0))) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            entity.m_6469_(CustomDamageSource.create(this.boss.m_9236_(), CustomDamageSource.OBLITERATED, (Entity)this.boss), this.getModifiedDamage(damage));
            entity.m_5997_(0.0, 1.0, 0.0);
            if (!living.m_21222_() || !living.m_21224_() || !this.isValidSpawn(living.m_20183_())) continue;
            this.summonRemnant(living.m_20182_());
        }
        if (!isSoundDelayed) {
            this.boss.m_9236_().m_5594_(null, this.targetPos, sound, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (!this.boss.m_9236_().f_46443_) {
            ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, this.targetPos.m_123341_(), this.targetPos.m_123342_(), this.targetPos.m_123343_(), ParticleEvents.OBLITERATE_MAP, 1.0f);
        }
    }

    private boolean isValidSpawn(BlockPos pos) {
        return this.boss.m_9236_().m_8055_(pos).m_60795_() && !this.boss.m_9236_().m_8055_(pos.m_7495_()).m_60795_();
    }

    private void obliterateLogic(LivingEntity target, int hitFrame, int followTargetTicks, int attackFinishedTicks, float damage, SoundEvent sound, boolean isSoundDelayed) {
        ++this.attackStatus;
        if (this.attackStatus < followTargetTicks && target.m_20183_() != null) {
            this.targetPos = target.m_20183_();
        } else if (this.targetPos != null) {
            this.boss.m_21563_().m_24946_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_());
            this.boss.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 0.0);
            this.yaw = this.boss.m_6080_();
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
            if (this.attackStatus == hitFrame) {
                this.smashGround(damage, sound, isSoundDelayed);
            }
            if (this.attackStatus >= attackFinishedTicks) {
                this.boss.m_21573_().m_26573_();
                this.resetAttack(1.0f, false, 1.0f);
            }
        }
    }

    private void maceOfSpadesLogic(LivingEntity target) {
        ++this.attackStatus;
        if (this.attackStatus < 3 && target.m_20183_() != null) {
            this.targetPos = target.m_20183_();
        } else if (this.targetPos != null) {
            LivingEntity livingEntity;
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
            this.boss.m_21563_().m_24946_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_());
            this.boss.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 0.0);
            if (this.attackStatus == 7) {
                for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB((double)(this.targetPos.m_123341_() - 5), (double)(this.targetPos.m_123342_() - 2), (double)(this.targetPos.m_123343_() - 5), (double)(this.targetPos.m_123341_() + 5), (double)(this.targetPos.m_123342_() + 2), (double)(this.targetPos.m_123343_() + 5)))) {
                    if (!(entity instanceof LivingEntity)) continue;
                    livingEntity = (LivingEntity)entity;
                    livingEntity.m_147240_(2.0, -(livingEntity.m_20185_() - this.boss.m_20185_()), -(livingEntity.m_20189_() - this.boss.m_20189_()));
                    livingEntity.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(20.0f));
                }
                this.boss.m_9236_().m_5594_(null, this.targetPos, (SoundEvent)SoundRegistry.KNIGHT_SWIPE_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.attackStatus == 13 && target.m_20183_() != null) {
                this.targetPos = target.m_20183_();
            }
            if (this.attackStatus == 21 && this.targetPos != null) {
                for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(this.targetPos).m_82400_(3.0))) {
                    if (!(entity instanceof LivingEntity)) continue;
                    livingEntity = (LivingEntity)entity;
                    livingEntity.m_5997_(0.0, 1.0, 0.0);
                    livingEntity.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(25.0f));
                }
                this.boss.m_9236_().m_5594_(null, this.targetPos, (SoundEvent)SoundRegistry.NIGHTFALL_BONK_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                if (!this.boss.m_9236_().f_46443_) {
                    ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, this.targetPos.m_123341_(), this.targetPos.m_123342_(), this.targetPos.m_123343_(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                }
            }
            if (this.attackStatus >= 36) {
                this.boss.m_21573_().m_26573_();
                this.resetAttack(1.0f, false, 1.0f);
            }
        }
    }

    private void ruptureLogic() {
        ++this.attackStatus;
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
        if (this.attackStatus == 21 || this.attackStatus == 33) {
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_(12.0))) {
                this.boss.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12599_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        }
        if (this.attackStatus == 52) {
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_(12.0))) {
                Remnant remnant;
                if (!(entity instanceof LivingEntity) || entity instanceof Remnant && (remnant = (Remnant)entity).m_21830_((LivingEntity)this.boss)) continue;
                entity.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(35.0f));
                this.boss.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
                entity.m_5997_(0.0, 1.0, 0.0);
                if (this.boss.m_9236_().f_46443_) continue;
                ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleEvents.GROUND_RUPTURE_MAP, 1.0f);
            }
        }
        if (this.attackStatus >= 70) {
            this.resetAttack(0.5f, true, 1.0f);
        }
    }

    private void blindingLightLogic() {
        ++this.attackStatus;
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
        if (this.attackStatus < 1) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_12001_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.attackStatus == 9) {
            if (!this.boss.m_9236_().f_46443_) {
                ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), ParticleEvents.BLINDING_LIGHT_SMASH_MAP, 1.0f);
            }
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), (SoundEvent)SoundRegistry.BLINDING_LIGHT_EXPLOSION_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_(3.0))) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                living.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(20.0f));
                living.m_147240_(3.0, -living.m_20185_() - this.boss.m_20185_(), -living.m_20189_() - this.boss.m_20189_());
                living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
            }
            if (this.boss.isPhaseTwo()) {
                int r = 3;
                int y = this.boss.m_20183_().m_123342_() + 1;
                for (int theta = 0; theta < 360; theta += 15) {
                    double x0 = this.boss.m_20185_();
                    double z0 = this.boss.m_20189_();
                    double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                    double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                    MoonlightProjectile projectile = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONLIGHT_ENTITY_TYPE.get()), this.boss.m_9236_());
                    projectile.setAgeAndPoints(15, 30, 1);
                    projectile.m_20343_(x, y, z);
                    projectile.m_37251_((Entity)this.boss, 0.0f, theta, 0.0f, 1.5f, 0.0f);
                    projectile.m_36781_(this.getModifiedDamage(15.0f));
                    this.boss.m_9236_().m_7967_((Entity)projectile);
                }
            }
        }
        if (this.attackStatus >= 24) {
            this.resetAttack(0.5f, false, 1.0f);
        }
    }

    private void summonLogic(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
        if (this.attackStatus == 30) {
            int enemyNumber = this.boss.m_217043_().m_188503_(3) + 3;
            RandomSummonPos pos = new RandomSummonPos(this.boss.m_9236_(), this.boss.m_217043_(), enemyNumber, 10, this.boss.m_20183_(), 10, 8, 5, this::summonRemnant);
            pos.applySummonSpawns();
            if (!this.boss.m_9236_().f_46443_) {
                ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, target.m_20185_(), target.m_20186_(), target.m_20189_(), ParticleEvents.GROUND_RUPTURE_MAP, 1.0f);
            }
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 140, 1));
            this.boss.m_9236_().m_5594_(null, target.m_20183_(), (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.HOSTILE, 0.7f, 1.0f);
        }
        if (this.attackStatus >= 48) {
            this.resetAttack(1.0f, true, 2.0f);
        }
    }

    private void summonRemnant(Vec3 pos) {
        Remnant entity = new Remnant((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.REMNANT.get()), this.boss.m_9236_());
        entity.m_146884_(pos);
        this.initEquip((LivingEntity)entity);
        this.boss.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        this.boss.m_9236_().m_7967_((Entity)entity);
        if (!this.boss.m_9236_().f_46443_) {
            ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 100, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
        }
    }

    private void initEquip(LivingEntity entity) {
        HashMap<ItemStack, EquipmentSlot> equip = new HashMap<ItemStack, EquipmentSlot>();
        equip.put(new ItemStack((ItemLike)Items.f_42480_), EquipmentSlot.HEAD);
        equip.put(new ItemStack((ItemLike)Items.f_42481_), EquipmentSlot.CHEST);
        equip.put(new ItemStack((ItemLike)Items.f_42482_), EquipmentSlot.LEGS);
        equip.put(new ItemStack((ItemLike)Items.f_42483_), EquipmentSlot.FEET);
        for (ItemStack stack : equip.keySet()) {
            stack.m_41663_(Enchantments.f_44965_, 2);
            stack.m_41663_(Enchantments.f_44963_, 1);
            entity.m_8061_((EquipmentSlot)equip.get(stack), stack);
        }
        entity.m_21153_(entity.m_21233_() * 1.5f);
    }
}

