/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.soulsweaponry.registry.EffectRegistry;

public class WitheredBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private final Block replacedBlock;

    public WitheredBlock(BlockBehaviour.Properties settings, Block replacedBlock) {
        super(settings);
        this.replacedBlock = replacedBlock;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.DECAY.get(), 40, 0));
        }
        super.m_141947_(world, pos, state, entity);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double x = random.m_188500_();
        double z = random.m_188500_();
        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + x, (double)pos.m_123342_() + (double)1.1f, (double)pos.m_123343_() + z, 0.0, 0.0, 0.0);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.m_213897_(state, world, pos, random);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if ((random.m_188503_(3) == 0 || this.canTurn((BlockGetter)world, pos, 4)) && world.m_46803_(pos) > 11 - (Integer)state.m_61143_((Property)AGE) - state.m_60739_((BlockGetter)world, pos) && this.increaseAge(state, (Level)world, pos)) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                mutable.m_122159_((Vec3i)pos, direction);
                BlockState blockState = world.m_8055_((BlockPos)mutable);
                if (!blockState.m_60713_((Block)this) || this.increaseAge(blockState, (Level)world, (BlockPos)mutable)) continue;
                world.m_186460_((BlockPos)mutable, (Block)this, Mth.m_216271_((RandomSource)random, (int)20, (int)40));
            }
            return;
        }
        world.m_186460_(pos, (Block)this, Mth.m_216271_((RandomSource)random, (int)20, (int)40));
    }

    protected boolean increaseAge(BlockState state, Level world, BlockPos pos) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 3) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.turnBack(world, pos);
        return true;
    }

    public void resetAge(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (sourceBlock.m_49966_().m_60713_((Block)this) && this.canTurn((BlockGetter)world, pos, 2)) {
            this.turnBack(world, pos);
        }
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
    }

    protected boolean canTurn(BlockGetter world, BlockPos pos, int maxNeighbors) {
        int i = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutable.m_122159_((Vec3i)pos, direction);
            if (!world.m_8055_((BlockPos)mutable).m_60713_((Block)this) || ++i < maxNeighbors) continue;
            return false;
        }
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    protected void turnBack(Level world, BlockPos pos) {
        world.m_46597_(pos, this.replacedBlock.m_49966_());
        world.m_46586_(pos, this.replacedBlock, pos);
    }
}

