/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import net.soulsweaponry.blocks.WitheredFlower;
import net.soulsweaponry.blocks.WitheredTallFlower;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.config.MidnightConfig;
import net.soulsweaponry.entity.mobs.DarkSorcerer;
import net.soulsweaponry.entity.mobs.EvilForlorn;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.GunRegistry;
import net.soulsweaponry.registry.ItemGroupRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.BetterBrewingRecipe;
import org.slf4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="soulsweapons")
public class SoulsWeaponry {
    public static final String ModId = "soulsweapons";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final List<RegistryObject<? extends Item>> ITEM_GROUP_LIST = new ArrayList<RegistryObject<? extends Item>>();

    public SoulsWeaponry() {
        MidnightConfig.init(ModId, ConfigConstructor.class);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        GeckoLib.initialize();
        ItemGroupRegistry.register(eventBus);
        SoundRegistry.register(eventBus);
        ParticleRegistry.register(eventBus);
        EffectRegistry.registerEffects(eventBus);
        EffectRegistry.registerPotions(eventBus);
        EnchantRegistry.register(eventBus);
        BlockRegistry.register(eventBus);
        ArmorRegistry.register();
        WeaponRegistry.register();
        GunRegistry.register();
        EntityRegistry.register(eventBus);
        ItemRegistry.register(eventBus);
        eventBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BetterBrewingRecipe(Potions.f_43602_, ((WitheredFlower)BlockRegistry.HYDRANGEA.get()).m_5456_(), (Potion)EffectRegistry.WARDING.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BetterBrewingRecipe(Potions.f_43602_, ((WitheredTallFlower)BlockRegistry.OLEANDER.get()).m_5456_(), (Potion)EffectRegistry.TAINTED_AMBROSIA.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BetterBrewingRecipe((Potion)EffectRegistry.WARDING.get(), Items.f_42525_, (Potion)EffectRegistry.STRONG_WARDING.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BetterBrewingRecipe((Potion)EffectRegistry.WARDING.get(), Items.f_42451_, (Potion)EffectRegistry.LONG_WARDING.get()));
            SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.WITHERED_DEMON.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
            SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.BIG_CHUNGUS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
            SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.EVIL_FORLORN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EvilForlorn::canSpawn);
            SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.DARK_SORCERER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DarkSorcerer::canSpawn);
        });
    }
}

