/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.datamap;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.datamap.StateVariantStringBuilder;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.util.JsonHelper;

public class BlockStateDataMapLoader<T>
extends SimpleJsonResourceReloadListener {
    private final String name;
    private final String folder;
    private final Loadable<T> dataLoader;
    private Map<BlockState, T> dataMap = Map.of();

    public BlockStateDataMapLoader(String name, String folder, Loadable<T> dataLoader) {
        super(JsonHelper.DEFAULT_GSON, folder);
        this.name = name;
        this.folder = folder;
        this.dataLoader = dataLoader;
    }

    protected Loadable<T> prepareLoader(Map<ResourceLocation, JsonElement> jsons) {
        return this.dataLoader;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        long time = System.nanoTime();
        HashMap<BlockState, T> dataMap = new HashMap<BlockState, T>();
        HashMap localMap = new HashMap();
        HashMap<ResourceLocation, T> locationMap = new HashMap<ResourceLocation, T>();
        Loadable<T> dataLoader = this.prepareLoader(jsons);
        for (Map.Entry entry : BuiltInRegistries.f_256975_.m_6579_()) {
            ResourceLocation location = ((ResourceKey)entry.getKey()).m_135782_();
            JsonElement element = jsons.get(location);
            if (element == null) continue;
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)location.toString());
                if (json.keySet().isEmpty()) continue;
                JsonObject variants = GsonHelper.m_13930_((JsonObject)json, (String)"variants");
                StateDefinition container = ((Block)entry.getValue()).m_49965_();
                ImmutableList validStates = container.m_61056_();
                for (Map.Entry variant : variants.entrySet()) {
                    Object data;
                    JsonElement variantElement = (JsonElement)variant.getValue();
                    String key = (String)variant.getKey();
                    if (variantElement.isJsonPrimitive()) {
                        ResourceLocation parent = JsonHelper.convertToResourceLocation(variantElement, key);
                        data = locationMap.get(parent);
                        if (data == null) {
                            JsonElement parentElement = jsons.get(parent);
                            if (parentElement == null) {
                                throw new JsonSyntaxException("Missing parent at " + parent + " for " + this.name + ", used in " + location);
                            }
                            data = dataLoader.convert(parentElement, parent.toString());
                            locationMap.put(parent, data);
                        }
                    } else {
                        data = dataLoader.convert(variantElement, key);
                    }
                    Object effectivelyFinal = data;
                    validStates.stream().filter(StateVariantStringBuilder.predicate((StateDefinition<Block, BlockState>)container, (String)variant.getKey())).forEach(state -> localMap.put(state, effectivelyFinal));
                }
                dataMap.putAll(localMap);
                localMap.clear();
            }
            catch (Exception e) {
                Mantle.logger.error("Failed to parse {} data for {}", (Object)this.name, (Object)location, (Object)e);
            }
        }
        this.dataMap = dataMap;
        Mantle.logger.info("Finished loading {} {} in {} ms", (Object)dataMap.size(), (Object)this.name, (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    @Nullable
    public T get(BlockState state) {
        return this.dataMap.get(state);
    }

    public T get(BlockState state, T defaultValue) {
        return this.dataMap.getOrDefault(state, defaultValue);
    }

    public String getFolder() {
        return this.folder;
    }

    public Loadable<T> getDataLoader() {
        return this.dataLoader;
    }
}

