/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import java.util.BitSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;

public class Area {
    int minX;
    int minZ;
    int maxX;
    int maxZ;

    public Area(ChunkPos min, ChunkPos max) {
        this.minX = min.f_45578_;
        this.minZ = min.f_45579_;
        this.maxX = max.f_45578_;
        this.maxZ = max.f_45579_;
    }

    public Area(ChunkPos center, int radius) {
        this.minX = center.f_45578_ - radius;
        this.minZ = center.f_45579_ - radius;
        this.maxX = center.f_45578_ + radius;
        this.maxZ = center.f_45579_ + radius;
    }

    public Area(ChunkPos pos, BitSet area) {
        this.minX = pos.f_45578_;
        this.minZ = pos.f_45579_;
        int x = 0;
        int z = 0;
        for (int i = 0; i < 1024; ++i) {
            if (!area.get(i)) continue;
            x = Math.max(x, i % 32);
            z = Math.max(z, i / 32);
        }
        this.maxX = this.minX + x + 1;
        this.maxZ = this.minZ + z + 1;
    }

    public Area(FriendlyByteBuf buffer) {
        this.minX = buffer.readInt();
        this.minZ = buffer.readInt();
        this.maxX = buffer.readInt();
        this.maxZ = buffer.readInt();
    }

    public int getMinX() {
        return this.minX << 4;
    }

    public int getMaxX() {
        return this.maxX << 4;
    }

    public int getMinZ() {
        return this.minZ << 4;
    }

    public int getMaxZ() {
        return this.maxZ << 4;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.minX);
        buffer.writeInt(this.minZ);
        buffer.writeInt(this.maxX);
        buffer.writeInt(this.maxZ);
    }
}

