/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.LongPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.common.base.PregenEvent;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.RetrogenManager;
import pregenerator.common.utils.misc.Area;
import pregenerator.common.utils.misc.ChunkWrapper;
import pregenerator.common.utils.misc.TrackedRegionFile;

public class ChunkEntry {
    public static final int STARTED = 1;
    public static final int FINISHED = 2;
    public static final int IS_SUB_STEP = 4;
    public static final int UNLOADED = 8;
    public static final int TASK_FINISHED = 16;
    public static final int RETRO_GENNING = 32;
    public static final int SKIP_MAIN = 64;
    private ChunkProcess process;
    private BitSet chunksToGenerate;
    private ChunkPos regionFilePos;
    private Area boundingBox;
    private int maxSize = 0;
    private int generationSize = 0;
    private int unloadProgress = 0;
    private int retrogenProgress = 0;
    private long[] chunks;
    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>[] tasks;
    private CompletableFuture<Void> validationTask;
    private CompletableFuture<Void> retrogenTask;
    private int flags = 0;
    private BitSet chunksToEvent = null;

    public ChunkEntry(ChunkProcess process, ChunkPos regionFilePos, BitSet chunksToGenerate) {
        this.process = process;
        this.chunksToGenerate = chunksToGenerate;
        this.regionFilePos = regionFilePos;
    }

    public boolean init(ChunkProcess.RegionProvider region, boolean event, LongPredicate predicate) {
        byte state = this.process.getMemory().getState(this.regionFilePos.m_45588_());
        if (state == 4) {
            return true;
        }
        BitSet file = region.get(this.regionFilePos.f_45578_, this.regionFilePos.f_45579_);
        for (int i = 0; i < 1024; ++i) {
            if (!this.chunksToGenerate.get(i)) continue;
            if (state >= 1 || this.isChunkValid(i % 32, i / 32, file, event, region) || predicate != null && !predicate.test(ChunkPos.m_45589_((int)(this.regionFilePos.f_45578_ + i % 32), (int)(this.regionFilePos.f_45579_ + i / 32)))) {
                ++this.maxSize;
                continue;
            }
            this.chunksToGenerate.clear(i);
        }
        this.generationSize = this.maxSize;
        if (event) {
            this.chunksToEvent = new BitSet(this.generationSize);
        }
        if (state >= 2) {
            this.flags |= 0x40;
        }
        this.boundingBox = new Area(this.regionFilePos, this.chunksToGenerate);
        return this.maxSize == 0;
    }

    public void startTask(boolean main) {
        this.generateCache();
        if (main) {
            this.process.getTaskType().startMainTask(this.chunks, this.tasks, this, this.process);
            this.process.getMemory().addEntry(this.regionFilePos, 1);
        } else {
            this.process.getTaskType().startSubTask(this.chunks, this.tasks, this.process);
            this.process.getMemory().addEntry(this.regionFilePos, 3);
            this.flags |= 4;
        }
        this.flags |= 1;
        this.flags &= 0xFFFFFFF5;
        this.unloadProgress = 0;
    }

    public int trackProgress() {
        int i;
        if (this.isValidating()) {
            return -1;
        }
        if (this.chunksToGenerate.isEmpty()) {
            return 0;
        }
        int done = 0;
        int m = this.tasks.length;
        for (i = 0; i < m; ++i) {
            if (!this.tasks[i].isDone()) continue;
            ++done;
        }
        if (done == this.generationSize) {
            if (this.process.getTaskType() == GenerationType.BLOCK_POST && (this.flags & 4) == 0) {
                ThreadedLevelLightEngine manager = this.process.getWorld().m_7726_().m_7827_();
                for (int i2 = 0; i2 < this.tasks.length; ++i2) {
                    ChunkAccess chunk = (ChunkAccess)this.tasks[i2].getNow((Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>)Either.left(null)).left().get();
                    if (!(chunk instanceof ProtoChunk)) continue;
                    ((ProtoChunk)chunk).m_7150_(ChunkStatus.f_62322_);
                    chunk.m_8092_(true);
                    ((ProtoChunk)chunk).m_63209_((LevelLightEngine)manager);
                }
                if (this.chunksToEvent != null) {
                    this.postEvents();
                    this.chunksToEvent.clear();
                }
            } else if (this.process.getTaskType() == GenerationType.RETROGEN) {
                if (this.retrogenTask != null && !this.retrogenTask.isDone()) {
                    return 0;
                }
                this.retrogenTask = null;
                for (i = 0; i < 50 && this.retrogenProgress < this.tasks.length; ++i) {
                    this.retrogenChunk((ChunkAccess)this.tasks[this.retrogenProgress++].getNow((Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>)Either.left(null)).left().get());
                }
                if (this.chunksToEvent != null) {
                    this.postEvents();
                }
                if (this.retrogenProgress < this.generationSize) {
                    return this.retrogenProgress;
                }
                done = this.retrogenProgress;
            } else if (this.chunksToEvent != null) {
                this.postEvents();
                this.chunksToEvent.clear();
            }
            this.flags |= 2;
        } else if (this.process.getTaskType() == GenerationType.RETROGEN) {
            done = 0;
        } else if (this.chunksToEvent != null) {
            this.postEvents();
        }
        return done;
    }

    public void postEvents() {
        if (this.tasks == null) {
            return;
        }
        for (int i = 0; i < this.tasks.length; ++i) {
            ChunkAccess chunk;
            if (this.chunksToEvent.get(i) || !this.tasks[i].isDone() || (chunk = (ChunkAccess)this.tasks[i].getNow((Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>)Either.left(null)).left().get()) == null) continue;
            this.chunksToEvent.set(i);
            MinecraftForge.EVENT_BUS.post((Event)new PregenEvent.Generated(this.process.getWorld(), this.process.taskName, this.process.taskId, chunk));
        }
    }

    public void retrogenChunk(ChunkAccess chunk) {
        if (!(chunk instanceof LevelChunk)) {
            return;
        }
        RetrogenManager.INSTANCE.retrogenChunks((LevelChunk)chunk, this.getChunks(chunk));
    }

    public List<ChunkAccess> getChunks(ChunkAccess center) {
        int i = center.m_7697_().f_45578_;
        int j = center.m_7697_().f_45579_;
        ObjectArrayList chunks = new ObjectArrayList();
        for (int k = -8; k <= 8; ++k) {
            for (int l = -8; l <= 8; ++l) {
                LevelChunk chunk = (LevelChunk)this.process.getChunk(ChunkPos.m_45589_((int)(i + l), (int)(j + k))).getNow((Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>)Either.left(null)).left().get();
                if (chunk == null) {
                    return null;
                }
                chunks.add(new ChunkWrapper(chunk));
            }
        }
        return chunks;
    }

    public int trackUnloading() {
        int end = Math.min(this.unloadProgress + ((this.flags & 4) == 0 ? 100 : 25), this.generationSize);
        if ((this.flags & 4) == 0 || !this.process.getTaskType().hasSubTask()) {
            this.process.getTaskType().unloadMainTask(this.chunks, this.unloadProgress, end, this.process);
        } else {
            this.process.getTaskType().unloadSubTask(this.chunks, this.unloadProgress, end, this.process);
        }
        this.unloadProgress = end;
        if (this.unloadProgress == this.generationSize) {
            this.flags |= 8;
            this.chunks = null;
            this.tasks = null;
            if ((this.flags & 4) != 0 || !this.process.getTaskType().hasSubTask()) {
                this.flags |= 0x10;
                this.process.getMemory().addEntry(this.regionFilePos, 4);
            } else {
                this.process.getMemory().addEntry(this.regionFilePos, 2);
            }
        }
        return this.unloadProgress;
    }

    public void interrupt() {
        if (this.validationTask != null && !this.validationTask.isDone()) {
            this.validationTask.complete(null);
        }
        if (this.chunks != null) {
            if ((this.flags & 4) == 0) {
                this.process.getTaskType().unloadMainTask(this.chunks, this.unloadProgress, this.generationSize, this.process);
            } else {
                this.process.getTaskType().unloadSubTask(this.chunks, this.unloadProgress, this.generationSize, this.process);
            }
        }
    }

    public boolean isValidating() {
        return this.validationTask != null;
    }

    public boolean isStarted() {
        return (this.flags & 1) != 0;
    }

    public boolean isFinished() {
        return (this.flags & 2) != 0;
    }

    public boolean isSkipped() {
        return (this.flags & 0x40) != 0;
    }

    public void removeSkip() {
        this.flags &= 0xFFFFFFBF;
    }

    public boolean isUnloaded() {
        return (this.flags & 8) != 0;
    }

    public boolean isTaskFinished() {
        return (this.flags & 0x10) != 0;
    }

    public boolean hasSubTask() {
        return this.process.getTaskType().hasSubTask();
    }

    void checkAccuratly(Executor taskManager) {
        boolean clearNull;
        boolean bl = clearNull = this.process.getTaskType() == GenerationType.POST_GEN || this.process.getTaskType() == GenerationType.RETROGEN;
        if (this.process.getFile(this.regionFilePos) == null) {
            if (this.process.getTaskType() == GenerationType.POST_GEN || this.process.getTaskType() == GenerationType.RETROGEN) {
                this.chunksToGenerate.clear();
                this.generationSize = 0;
            }
            return;
        }
        this.validationTask = CompletableFuture.runAsync(() -> {
            TrackedRegionFile file = this.process.getFile(this.regionFilePos);
            if (file == null) {
                return;
            }
            ChunkStatus.ChunkType type = this.process.getTaskType() == GenerationType.RETROGEN ? ChunkStatus.ChunkType.PROTOCHUNK : ChunkStatus.ChunkType.LEVELCHUNK;
            for (int i = 0; i < 1024; ++i) {
                if (!this.chunksToGenerate.get(i)) continue;
                ChunkPos chunkPos = new ChunkPos(i % 32, i / 32);
                if (!file.m_63682_(chunkPos)) {
                    if (!clearNull) continue;
                    this.chunksToGenerate.clear(i);
                    --this.generationSize;
                    continue;
                }
                if (!file.isValid()) {
                    file = this.process.getFile(this.regionFilePos);
                }
                try (DataInputStream stream = file.m_63645_(chunkPos);){
                    if (ChunkSerializer.m_63485_((CompoundTag)NbtIo.m_128928_((DataInput)stream)) == type) {
                        this.chunksToGenerate.clear(i);
                        --this.generationSize;
                    }
                }
                catch (Exception e) {
                    ChunkPregenerator.LOGGER.info("This should never happen!");
                    ChunkPregenerator.LOGGER.catching((Throwable)e);
                }
                this.process.validationProgress.addAndGet(1L);
            }
        }, taskManager).thenAcceptAsync(T -> {
            this.validationTask = null;
        }, (Executor)ServerLifecycleHooks.getCurrentServer());
    }

    protected boolean isChunkValid(int x, int z, BitSet file, boolean spawn, ChunkProcess.RegionProvider region) {
        switch (this.process.getTaskType()) {
            case TERRAIN_ONLY: {
                return this.isChunkGenerated(x, z, file, false, spawn, region) != InteractionResult.SUCCESS;
            }
            case BLOCK_POST: {
                return this.isChunkGenerated(x, z, file, false, spawn, region) != InteractionResult.SUCCESS;
            }
            case FAST_CHECK_GEN: {
                return this.isChunkGenerated(x, z, file, false, spawn, region) != InteractionResult.SUCCESS;
            }
            case NORMAL_GEN: {
                return true;
            }
            case POST_GEN: {
                return this.isChunkGenerated(x, z, file, true, spawn, region) == InteractionResult.SUCCESS;
            }
            case RETROGEN: {
                return this.isChunkGenerated(x, z, file, true, spawn, region) == InteractionResult.SUCCESS;
            }
        }
        return false;
    }

    protected InteractionResult isChunkGenerated(int x, int z, BitSet file, boolean full, boolean spawn, ChunkProcess.RegionProvider region) {
        int regionX = this.regionFilePos.f_45578_ + x;
        int regionZ = this.regionFilePos.f_45579_ + z;
        if (this.process.getProvider().m_5563_(regionX, regionZ)) {
            return InteractionResult.SUCCESS;
        }
        if (file.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (file.get(z * 32 + x)) {
            return !full && this.isUnfinished(regionX, regionZ, region) ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean isUnfinished(int x, int z, ChunkProcess.RegionProvider region) {
        for (int i = 1; i < 26; ++i) {
            if (region.getChunk(x + i, z) && region.getChunk(x - i, z) && region.getChunk(x, z + i) && region.getChunk(x, z - i)) continue;
            return true;
        }
        return false;
    }

    long getDistanceToCenter(ChunkPos center) {
        long x = this.regionFilePos.f_45578_ - center.f_45578_;
        long z = this.regionFilePos.f_45579_ - center.f_45579_;
        return x * x + z * z;
    }

    void generateCache() {
        if (this.chunks == null) {
            this.chunks = new long[this.generationSize];
            int index = 0;
            for (int i = 0; i < 1024; ++i) {
                if (!this.chunksToGenerate.get(i)) continue;
                this.chunks[index++] = ChunkPos.m_45589_((int)(this.regionFilePos.f_45578_ + i % 32), (int)(this.regionFilePos.f_45579_ + i / 32));
            }
        }
        if (this.tasks == null) {
            this.tasks = new CompletableFuture[this.generationSize];
        }
    }

    public Area getBoundingBox() {
        return this.boundingBox;
    }

    public int getTotalSize() {
        return this.maxSize;
    }

    public int getGenerationSize() {
        return this.generationSize;
    }

    public void setRetrogenTask(CompletableFuture<Void> allOf) {
        this.retrogenTask = allOf;
    }
}

