/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.base.impl.comp.PregenCheckBox;
import pregenerator.base.impl.comp.PregenText;
import pregenerator.base.impl.comp.PregenTreeList;
import pregenerator.common.generator.RetrogenManager;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.RetrogenPacket;

public class RetrogenScreen
extends BasePregenScreen {
    Component header = TextUtil.translate("gui.chunk_pregen.retrogen_selector.header");
    PregenCheckBox.CheckboxState showMods = new PregenCheckBox.CheckboxState(true, true, (Component)TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_mods"));
    PregenTreeList.TreeState<RetrogenNode> selectors = new PregenTreeList.TreeState().setRowWidth(350);
    PregenText.TextState search = new PregenText.TextState("", "Search").setCallback(this.selectors::search);
    PregenCheckBox.CheckboxState showFrame = new PregenCheckBox.CheckboxState(true, false, (Component)TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_frame")).withStateListener(this.selectors::setFrame);
    Screen parent;

    public RetrogenScreen(Screen parent) {
        super((Component)TextUtil.guiConstructor());
        this.parent = parent;
        this.sendToServer(new RetrogenPacket.Request());
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.tree(this.f_96543_, this.f_96544_, 50, this.f_96544_ - 36, this.selectors);
        this.text(-80, 21, 160, 18, Align.CENTER, Align.START, this.search);
        this.checkbox(85, 15, 14, 14, Align.CENTER, Align.START, this.showMods);
        this.checkbox(85, 30, 14, 14, Align.CENTER, Align.START, this.showFrame);
        this.button(-60, -28, 120, 20, Align.CENTER, Align.END, (Component)TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.m_7379_());
    }

    public void m_7379_() {
        this.setScreen(this.parent);
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawText(graphics, this.header, 0.0f, -this.centerY + 6, Align.CENTER, -1);
    }

    public void acceptMapped(Map<String, Map<String, List<ResourceLocation>>> mapped) {
        this.selectors.replaceNodes(this.createNode(mapped));
    }

    public List<RetrogenNode> createNode(Map<String, Map<String, List<ResourceLocation>>> mapped) {
        ObjectArrayList nodes = new ObjectArrayList();
        ObjectArrayList mods = new ObjectArrayList(mapped.keySet());
        mods.sort(String.CASE_INSENSITIVE_ORDER);
        for (String mod : mods) {
            ModNode modNode = new ModNode(mod);
            for (Map.Entry<String, List<ResourceLocation>> category : mapped.get(mod).entrySet()) {
                List<ResourceLocation> locations = category.getValue();
                if (locations.size() > 1) {
                    CategoryNode categoryNode = new CategoryNode(category.getKey(), mod, this.showMods);
                    for (ResourceLocation feature : category.getValue()) {
                        categoryNode.addChildNode(new FeatureNode(feature, this.showMods));
                    }
                    modNode.addChildNode(categoryNode);
                    continue;
                }
                modNode.addChildNode(new FeatureNode(locations.get(0), this.showMods));
            }
            nodes.add(modNode);
        }
        return nodes;
    }

    public class ModNode
    extends RetrogenNode {
        Component text;

        public ModNode(String modId) {
            this.text = TextUtil.getModName(modId).m_130940_(ChatFormatting.GOLD);
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.m_6311_(graphics, x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            float f = left + 20;
            int n = top + height / 2;
            Objects.requireNonNull(this.font);
            RetrogenScreen.this.drawUnalignedText(graphics, this.text, f, n - 9 / 2, Align.START, -1);
        }

        @Override
        public int getItemHeight() {
            return 16;
        }
    }

    public class CategoryNode
    extends RetrogenNode {
        Component text;
        Component modId;
        PregenCheckBox.CheckboxState showMods;

        public CategoryNode(String category, String mod, PregenCheckBox.CheckboxState showMods) {
            this.text = TextUtil.literalPascal(category).m_130940_(ChatFormatting.GOLD);
            this.modId = TextUtil.getModName(mod).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
            this.showMods = showMods;
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.m_6311_(graphics, x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            if (this.showMods.isChecked()) {
                float f = left + 20;
                int n = top + height / 3;
                Objects.requireNonNull(this.font);
                RetrogenScreen.this.drawUnalignedText(graphics, this.text, f, n - 9 / 2 - 1, Align.START, -1);
                float f2 = left + 20;
                int n2 = top + height / 3;
                Objects.requireNonNull(this.font);
                RetrogenScreen.this.drawUnalignedText(graphics, this.modId, f2, n2 + 9 / 2 + 1, Align.START, -1);
            } else {
                float f = left + 20;
                int n = top + height / 2;
                Objects.requireNonNull(this.font);
                RetrogenScreen.this.drawUnalignedText(graphics, this.text, f, n - 9 / 2, Align.START, -1);
            }
        }

        @Override
        public int getItemHeight() {
            return this.showMods.isChecked() ? 24 : 16;
        }
    }

    public class FeatureNode
    extends RetrogenNode {
        ResourceLocation id;
        Component text;
        Component modId;
        PregenCheckBox.CheckboxState showMods;

        public FeatureNode(ResourceLocation id, PregenCheckBox.CheckboxState showMods) {
            this.id = id;
            this.text = TextUtil.literalPascal(id.m_135815_()).m_130940_(ChatFormatting.GOLD);
            this.modId = TextUtil.getModName(id.m_135827_()).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
            this.showMods = showMods;
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.m_6311_(graphics, x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            if (this.showMods.isChecked()) {
                float f = left + 20;
                int n = top + height / 3;
                Objects.requireNonNull(this.font);
                RetrogenScreen.this.drawUnalignedText(graphics, this.text, f, n - 9 / 2 - 1, Align.START, -1);
                float f2 = left + 20;
                int n2 = top + height / 3;
                Objects.requireNonNull(this.font);
                RetrogenScreen.this.drawUnalignedText(graphics, this.modId, f2, n2 + 9 / 2 + 1, Align.START, -1);
            } else {
                float f = left + 20;
                int n = top + height / 2;
                Objects.requireNonNull(this.font);
                RetrogenScreen.this.drawUnalignedText(graphics, this.text, f, n - 9 / 2, Align.START, -1);
            }
        }

        @Override
        public int getItemHeight() {
            return this.showMods.isChecked() ? 24 : 16;
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return this.searchResourceLocation(searchString, this.id);
        }

        @Override
        protected State getState() {
            return RetrogenManager.INSTANCE.isActive(this.id) ? State.ENABLED : State.DISABLED;
        }

        @Override
        protected void setState(boolean value) {
            if (value) {
                RetrogenManager.INSTANCE.enableFeature(this.id);
            } else {
                RetrogenManager.INSTANCE.disableFeature(this.id);
            }
            NetworkManager.INSTANCE.sendToServer(new RetrogenPacket.Change(this.id, value));
        }
    }

    public static abstract class RetrogenNode
    extends PregenTreeList.TreeEntry<RetrogenNode> {
        PregenButton enable = this.addChild(new PregenButton(0, 0, 50, 14, (Component)TextUtil.translate("gui.chunk_pregen.retrogen_selector.enable"), T -> this.setState(true)));
        PregenButton disable = this.addChild(new PregenButton(0, 0, 50, 14, (Component)TextUtil.translate("gui.chunk_pregen.retrogen_selector.disable"), T -> this.setState(false)));

        protected State getState() {
            int state = 0;
            for (RetrogenNode node : this.childNodes()) {
                state |= 1 << node.getState().ordinal();
            }
            if ((state & 4) != 0) {
                return State.UNKNOWN;
            }
            int value = state & 3;
            if (value == 3) {
                return State.UNKNOWN;
            }
            return value == 1 ? State.ENABLED : State.DISABLED;
        }

        protected void setState(boolean value) {
            this.childNodes().forEach(T -> T.setState(value));
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return false;
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.m_6311_(graphics, x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            State state = this.getState();
            this.enable.f_93623_ = state != State.ENABLED;
            this.enable.m_252865_(left + width - (this.enable.m_5711_() + this.disable.m_5711_() + 4));
            this.enable.m_253211_(top + height / 2 - this.enable.m_93694_() / 2);
            this.enable.m_88315_(graphics, mouseX, mouseY, partialTicks);
            this.disable.f_93623_ = state != State.DISABLED;
            this.disable.m_252865_(left + width - this.disable.m_5711_() - 3);
            this.disable.m_253211_(top + height / 2 - this.disable.m_93694_() / 2);
            this.disable.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private static enum State {
        ENABLED,
        DISABLED,
        UNKNOWN;

    }
}

