/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.network;

import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.PayloadWrapper;
import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.SortingMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public record ClientBoundItemListPayload(List<ItemStack> existingItems, List<ItemStack> craftableItems, BlockPos networkPos, BlockPos requestPos, SortingMode sortingMode) implements PayloadWrapper<ClientBoundItemListPayload>
{
    public static final ResourceLocation TYPE = MiscUtil.resourceLocation("item_list");
    public static final SelfHandler<ClientBoundItemListPayload> HANDLER = new Handler();

    @Override
    public SelfHandler<ClientBoundItemListPayload> getHandler() {
        return HANDLER;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    private static class Handler
    extends SelfHandler<ClientBoundItemListPayload> {
        private Handler() {
        }

        @Override
        public FriendlyByteBuf encode(ClientBoundItemListPayload payload, FriendlyByteBuf buffer) {
            buffer.m_236828_(payload.existingItems(), MiscUtil::writeStackToBuffer);
            buffer.m_236828_(payload.craftableItems(), MiscUtil::writeStackToBuffer);
            buffer.m_130064_(payload.networkPos());
            buffer.m_130064_(payload.requestPos());
            buffer.writeByte((int)payload.sortingMode().getValue());
            return buffer;
        }

        @Override
        public ClientBoundItemListPayload decode(FriendlyByteBuf buffer) {
            List existingItems = (List)buffer.m_236838_(ArrayList::new, MiscUtil::readStackFromBuffer);
            List craftableItems = (List)buffer.m_236838_(ArrayList::new, MiscUtil::readStackFromBuffer);
            BlockPos networkPos = buffer.m_130135_();
            BlockPos requestPos = buffer.m_130135_();
            SortingMode sortingMode = SortingMode.fromByte(buffer.readByte());
            return new ClientBoundItemListPayload(existingItems, craftableItems, networkPos, requestPos, sortingMode);
        }

        @Override
        public void handle(ClientBoundItemListPayload payload, Player player) {
            RequestMenu menu;
            AbstractContainerMenu abstractContainerMenu;
            if (player != null && (abstractContainerMenu = player.f_36096_) instanceof RequestMenu && (menu = (RequestMenu)abstractContainerMenu).getNetworkPos().equals((Object)payload.networkPos())) {
                menu.update(payload.existingItems(), payload.craftableItems());
            }
        }
    }
}

